/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.XmlFile;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.robot.Messages;
import hudson.plugins.robot.RobotConfig;
import hudson.plugins.robot.graph.RobotGraph;
import hudson.plugins.robot.graph.RobotGraphHelper;
import hudson.plugins.robot.model.RobotCaseResult;
import hudson.plugins.robot.model.RobotResult;
import hudson.plugins.robot.model.RobotSuiteResult;
import hudson.plugins.robot.model.RobotTestObject;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.util.ChartUtil;
import hudson.util.HeapSpaceStringConverter;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@SuppressFBWarnings(value={"UG_SYNC_SET_UNSYNC_GET"}, justification="Methods are synchronized")
public class RobotBuildAction
extends AbstractTestResultAction<RobotBuildAction>
implements StaplerProxy {
    private static final Logger logger = Logger.getLogger(RobotBuildAction.class.getName());
    private static final XStream XSTREAM = new XStream2();
    private transient WeakReference<RobotResult> resultReference;
    private transient String reportFileName;
    private String outputPath;
    private String logFileLink;
    private String logHtmlLink;
    private final boolean enableCache;
    private Run<?, ?> build;
    private RobotResult result;
    private String xAxisLabel;

    public RobotBuildAction(Run<?, ?> build, RobotResult result, String outputPath, TaskListener listener, String logFileLink, String logHtmlLink, boolean enableCache, String xAxisLabel) {
        super.onAttached(build);
        this.build = build;
        this.outputPath = outputPath;
        this.logFileLink = logFileLink;
        this.logHtmlLink = logHtmlLink;
        this.enableCache = enableCache;
        this.xAxisLabel = xAxisLabel;
        this.setResult(result, listener);
    }

    public Run<?, ?> getOwner() {
        return this.build;
    }

    public String getLogFileLink() {
        return this.logFileLink;
    }

    public String getLogHtmlLink() {
        return this.logHtmlLink;
    }

    public synchronized void setResult(RobotResult result, TaskListener listener) {
        block2: {
            result.tally(this);
            try {
                this.getDataFile().write((Object)result);
            }
            catch (IOException e) {
                if (listener == null) break block2;
                e.printStackTrace(listener.fatalError("Failed to save the Robot test result"));
            }
        }
        this.cacheRobotResult(result);
    }

    public synchronized RobotResult getResult() {
        RobotResult returnable;
        if (this.result != null) {
            return this.result;
        }
        if (this.resultReference == null) {
            returnable = this.load();
            this.cacheRobotResult(returnable);
        } else {
            returnable = (RobotResult)this.resultReference.get();
        }
        if (returnable == null) {
            returnable = this.load();
            this.cacheRobotResult(returnable);
        }
        return returnable;
    }

    private XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.getOwner().getRootDir(), "robot_results.xml"));
    }

    private void cacheRobotResult(RobotResult result) {
        if (this.enableCache) {
            this.resultReference = new WeakReference<RobotResult>(result);
        }
    }

    private RobotResult load() {
        RobotResult loadedResult;
        try {
            loadedResult = (RobotResult)this.getDataFile().read();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Couldn't load " + this.getDataFile(), e);
            return null;
        }
        loadedResult.tally(this);
        return loadedResult;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public double getOverallPassPercentage() {
        return this.getResult().getPassPercentage(false);
    }

    public double getCriticalPassPercentage() {
        return this.getResult().getPassPercentage(true);
    }

    public RobotTestObject findObjectById(String id) {
        return this.getResult().findObjectById(id);
    }

    public Object getTarget() {
        if (this.reportFileName != null) {
            return this;
        }
        return this.getResult();
    }

    public String getxAxisLabel() {
        return this.xAxisLabel;
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        String indexFile = this.getReportFileName();
        FilePath robotDir = this.getRobotDir();
        if (!new FilePath(robotDir, indexFile).exists()) {
            rsp.sendRedirect("notfound");
            return;
        }
        DirectoryBrowserSupport dbs = new DirectoryBrowserSupport((ModelObject)this, this.getRobotDir(), this.getDisplayName(), "folder.gif", false);
        dbs.setIndexFileName(indexFile);
        dbs.generateResponse(req, rsp, (Object)this);
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Calendar t = this.build.getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        String maxBuildsReq = req.getParameter("maxBuildsToShow");
        if (maxBuildsReq == null || maxBuildsReq.isEmpty()) {
            maxBuildsReq = "0";
        }
        String labelFormat = StringUtils.isBlank((String)this.xAxisLabel) ? RobotConfig.getInstance().getXAxisLabelFormat() : this.xAxisLabel;
        RobotGraph g = RobotGraphHelper.createTestResultsGraphForTestObject(this.getResult(), Boolean.valueOf(req.getParameter("zoomSignificant")), false, Boolean.valueOf(req.getParameter("hd")), Boolean.valueOf(req.getParameter("failedOnly")), Boolean.valueOf(req.getParameter("criticalOnly")), labelFormat, Integer.parseInt(maxBuildsReq));
        g.doPng(req, rsp);
    }

    public FilePath getRobotDir() {
        FilePath rootDir = new FilePath(this.build.getRootDir());
        if (StringUtils.isNotBlank((String)this.outputPath)) {
            return new FilePath(rootDir, this.outputPath);
        }
        return rootDir;
    }

    public int getFailCount() {
        return (int)this.getResult().getOverallFailed();
    }

    public int getTotalCount() {
        return (int)this.getResult().getOverallTotal();
    }

    public String getIconFileName() {
        return "/plugin/robot/robot.png";
    }

    public String getDisplayName() {
        return Messages.robot_sidebar_link();
    }

    public String getUrlName() {
        return "robot";
    }

    public List<RobotCaseResult> getAllTests() {
        return this.getResult().getAllCases();
    }

    static {
        XSTREAM.alias("result", RobotResult.class);
        XSTREAM.alias("suite", RobotSuiteResult.class);
        XSTREAM.alias("case", RobotCaseResult.class);
        XSTREAM.registerConverter((SingleValueConverter)new HeapSpaceStringConverter(), 100);
    }
}

