/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.robot.Messages;
import hudson.plugins.robot.RobotBuildAction;
import hudson.plugins.robot.RobotParser;
import hudson.plugins.robot.RobotProjectAction;
import hudson.plugins.robot.RobotResultAggregator;
import hudson.plugins.robot.model.RobotResult;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RobotPublisher
extends Recorder
implements Serializable,
MatrixAggregatable,
SimpleBuildStep {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_REPORT_FILE = "report.html";
    protected static final String DEFAULT_ARCHIVE_DIR = "robot-plugin";
    protected static final String DEFAULT_JENKINS_ARCHIVE_DIR = "archive";
    private static final String DEFAULT_OUTPUT_FILE = "output.xml";
    private static final String DEFAULT_LOG_FILE = "log.html";
    private final String archiveDirName;
    private final String outputPath;
    private final String reportFileName;
    private final String logFileName;
    private final String outputFileName;
    private final boolean disableArchiveOutput;
    private final double passThreshold;
    private final double unstableThreshold;
    private String[] otherFiles;
    private final String overwriteXAxisLabel;
    private final boolean enableCache;
    private boolean onlyCritical = true;

    @DataBoundConstructor
    public RobotPublisher(String archiveDirName, String outputPath, String outputFileName, boolean disableArchiveOutput, String reportFileName, String logFileName, double passThreshold, double unstableThreshold, boolean onlyCritical, String otherFiles, boolean enableCache, String overwriteXAxisLabel) {
        this.archiveDirName = archiveDirName;
        this.outputPath = outputPath;
        this.outputFileName = outputFileName;
        this.disableArchiveOutput = disableArchiveOutput;
        this.reportFileName = reportFileName;
        this.passThreshold = passThreshold;
        this.unstableThreshold = unstableThreshold;
        this.logFileName = logFileName;
        this.onlyCritical = onlyCritical;
        this.enableCache = enableCache;
        this.overwriteXAxisLabel = overwriteXAxisLabel;
        if (otherFiles != null) {
            String[] filemasks = otherFiles.split(",");
            for (int i = 0; i < filemasks.length; ++i) {
                filemasks[i] = StringUtils.strip((String)filemasks[i]);
            }
            this.otherFiles = filemasks;
        }
    }

    public String getArchiveDirName() {
        if (StringUtils.isBlank((String)this.archiveDirName)) {
            return DEFAULT_ARCHIVE_DIR;
        }
        return this.archiveDirName;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public String getOutputFileName() {
        if (StringUtils.isBlank((String)this.outputFileName)) {
            return DEFAULT_OUTPUT_FILE;
        }
        return this.outputFileName;
    }

    public boolean getDisableArchiveOutput() {
        return this.disableArchiveOutput;
    }

    public String getReportFileName() {
        if (StringUtils.isBlank((String)this.reportFileName)) {
            return DEFAULT_REPORT_FILE;
        }
        return this.reportFileName;
    }

    public String getLogFileName() {
        if (StringUtils.isBlank((String)this.logFileName)) {
            return DEFAULT_LOG_FILE;
        }
        return this.logFileName;
    }

    public double getPassThreshold() {
        return this.passThreshold;
    }

    public double getUnstableThreshold() {
        return this.unstableThreshold;
    }

    public boolean getOnlyCritical() {
        return this.onlyCritical;
    }

    public boolean getEnableCache() {
        return this.enableCache;
    }

    public String getOtherFiles() {
        return StringUtils.join((Object[])this.otherFiles, (String)",");
    }

    public String getOverwriteXAxisLabel() {
        return this.overwriteXAxisLabel;
    }

    public Collection<Action> getProjectActions(AbstractProject<?, ?> project) {
        ArrayList<Action> actions = new ArrayList<Action>();
        RobotProjectAction roboAction = new RobotProjectAction((Job<?, ?>)project);
        actions.add(roboAction);
        return actions;
    }

    protected RobotResult parse(String expandedTestResults, String expandedLogFileName, String expandedReportFileName, String outputPath, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return new RobotParser().parse(expandedTestResults, outputPath, build, workspace, expandedLogFileName, expandedReportFileName);
    }

    public void perform(Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull EnvVars buildEnv, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        block11: {
            if (build.getResult() != Result.ABORTED) {
                PrintStream logger = listener.getLogger();
                logger.println(Messages.robot_publisher_started());
                logger.println(Messages.robot_publisher_only_critical());
                logger.println(Messages.robot_publisher_parsing());
                try {
                    String expandedOutputFileName = buildEnv.expand(this.getOutputFileName());
                    String expandedOutputPath = buildEnv.expand(this.getOutputPath());
                    String expandedReportFileName = buildEnv.expand(this.getReportFileName());
                    String expandedLogFileName = buildEnv.expand(this.getLogFileName());
                    String logFileJavascripts = RobotPublisher.trimSuffix(expandedLogFileName) + ".js";
                    RobotResult result = this.parse(expandedOutputFileName, expandedLogFileName, expandedReportFileName, expandedOutputPath, build, workspace, launcher, listener);
                    logger.println(Messages.robot_publisher_done());
                    FilePath outputDir = new FilePath(workspace, expandedOutputPath);
                    if (outputDir.list(expandedLogFileName).length == 0) {
                        logger.println(Messages.robot_publisher_file_not_found() + " " + expandedLogFileName);
                    }
                    if (outputDir.list(expandedReportFileName).length == 0) {
                        logger.println(Messages.robot_publisher_file_not_found() + " " + expandedReportFileName);
                    }
                    if (!DEFAULT_JENKINS_ARCHIVE_DIR.equalsIgnoreCase(this.getArchiveDirName())) {
                        logger.println(Messages.robot_publisher_copying());
                        this.copyFilesToBuildDir(build, workspace, expandedOutputPath, StringUtils.join((Object[])RobotPublisher.modifyMasksforSplittedOutput(new String[]{expandedReportFileName, expandedLogFileName, logFileJavascripts}), (String)","));
                        if (!this.getDisableArchiveOutput()) {
                            this.copyFilesToBuildDir(build, workspace, expandedOutputPath, StringUtils.join((Object[])RobotPublisher.modifyMasksforSplittedOutput(new String[]{expandedOutputFileName}), (String)","));
                        }
                        if (StringUtils.isNotBlank((String)this.getOtherFiles())) {
                            String filemask = buildEnv.expand(this.getOtherFiles());
                            this.copyFilesToBuildDir(build, workspace, expandedOutputPath, filemask);
                        }
                        logger.println(Messages.robot_publisher_done());
                    }
                    logger.println(Messages.robot_publisher_assigning());
                    String label = buildEnv.expand(this.overwriteXAxisLabel);
                    RobotBuildAction action = new RobotBuildAction(build, result, this.getArchiveDirName(), listener, expandedReportFileName, expandedLogFileName, this.enableCache, label);
                    build.addAction((Action)action);
                    Job job = build.getParent();
                    if (job == null) break block11;
                    RobotProjectAction projectAction = new RobotProjectAction(job);
                    try {
                        job.addOrReplaceAction((Action)projectAction);
                    }
                    catch (NullPointerException | UnsupportedOperationException runtimeException) {
                        // empty catch block
                    }
                    logger.println(Messages.robot_publisher_done());
                    logger.println(Messages.robot_publisher_checking());
                    Result buildResult = this.getBuildResult(build, result);
                    build.setResult(buildResult);
                    logger.println(Messages.robot_publisher_done());
                    logger.println(Messages.robot_publisher_finished());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.println(Messages.robot_publisher_fail());
                    e.printStackTrace(logger);
                    build.setResult(Result.FAILURE);
                }
            }
        }
    }

    public void copyFilesToBuildDir(Run<?, ?> build, FilePath workspace, String inputPath, String filemaskToCopy) throws IOException, InterruptedException {
        FilePath srcDir = new FilePath(workspace, inputPath);
        FilePath destDir = new FilePath(new FilePath(build.getRootDir()), this.getArchiveDirName());
        srcDir.copyRecursiveTo(filemaskToCopy, destDir);
    }

    public static String trimSuffix(String filename) {
        int index = filename.lastIndexOf(46);
        if (index > 0) {
            filename = filename.substring(0, index);
        }
        return filename;
    }

    public static String getSuffix(String filename) {
        int index = filename.lastIndexOf(46);
        if (index > 0) {
            return filename.substring(index);
        }
        return "";
    }

    private static String[] modifyMasksforSplittedOutput(String[] filemasks) {
        for (int i = 0; i < filemasks.length; ++i) {
            filemasks[i] = RobotPublisher.trimSuffix(filemasks[i]) + "*" + RobotPublisher.getSuffix(filemasks[i]);
        }
        return filemasks;
    }

    protected Result getBuildResult(Run<?, ?> build, RobotResult result) {
        if (build.getResult() != Result.FAILURE) {
            double passPercentage = result.getPassPercentage(this.onlyCritical);
            if (passPercentage < this.getUnstableThreshold()) {
                return Result.FAILURE;
            }
            if (passPercentage < this.getPassThreshold()) {
                return Result.UNSTABLE;
            }
            return Result.SUCCESS;
        }
        return Result.FAILURE;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new RobotResultAggregator(build, launcher, listener);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.robot_description();
        }

        public FormValidation doCheckUnstableThreshold(@QueryParameter String value) throws IOException, ServletException {
            if (this.isPercentageValue(value)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.robot_config_percentvalidation());
        }

        public FormValidation doCheckPassThreshold(@QueryParameter String value) throws IOException, ServletException {
            if (this.isPercentageValue(value)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.robot_config_percentvalidation());
        }

        private boolean isPercentageValue(String value) {
            try {
                double doubleValue = Double.parseDouble(value);
                return doubleValue <= 100.0 && doubleValue >= 0.0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

