/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot.model;

import hudson.plugins.robot.RobotBuildAction;
import hudson.plugins.robot.model.RobotCaseComparator;
import hudson.plugins.robot.model.RobotCaseResult;
import hudson.plugins.robot.model.RobotResult;
import hudson.plugins.robot.model.RobotTestObject;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kohsuke.stapler.StaplerRequest;

public class RobotSuiteResult
extends RobotTestObject {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger((String)RobotSuiteResult.class.getName());
    private Map<String, RobotSuiteResult> children;
    private RobotTestObject parent;
    private String name;
    private String description;
    private Map<String, RobotCaseResult> caseResults;
    private String elapsedTime;
    private String startTime;
    private String endTime;
    private transient int failed;
    private transient int passed;
    private transient int skipped;
    private transient int criticalPassed;
    private transient int criticalFailed;
    private int schemaVersion;

    public void addChild(RobotSuiteResult child) {
        String originalName;
        if (this.children == null) {
            this.children = new HashMap<String, RobotSuiteResult>();
        }
        int i = 1;
        String checkedSuiteName = originalName = child.getName();
        while (this.children.get(checkedSuiteName) != null) {
            checkedSuiteName = originalName + "_" + i;
            ++i;
        }
        child.setDuplicateSafeName(checkedSuiteName);
        this.children.put(checkedSuiteName, child);
    }

    public Collection<RobotSuiteResult> getChildSuites() {
        if (this.children != null) {
            return this.children.values();
        }
        return Collections.emptyList();
    }

    @Override
    public RobotTestObject getParent() {
        return this.parent;
    }

    public void setParent(RobotTestObject parent) {
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Collection<RobotCaseResult> getCaseResults() {
        if (this.caseResults != null) {
            ArrayList<RobotCaseResult> res = new ArrayList<RobotCaseResult>(this.caseResults.values());
            res.sort(new RobotCaseComparator());
            return res;
        }
        return Collections.emptyList();
    }

    @Override
    public int getFailed() {
        return this.failed;
    }

    @Override
    public int getPassed() {
        return this.passed;
    }

    @Override
    public int getSkipped() {
        return this.skipped;
    }

    public int getTotal() {
        return this.passed + this.failed + this.skipped;
    }

    @Override
    public long getCriticalPassed() {
        return this.criticalPassed;
    }

    @Override
    public long getCriticalFailed() {
        return this.criticalFailed;
    }

    public int getCriticalTotal() {
        return this.criticalPassed + this.criticalFailed;
    }

    public void setSchemaVersion(int version) {
        this.schemaVersion = version;
    }

    public void addCaseResult(RobotCaseResult caseResult) {
        String originalName;
        if (this.caseResults == null) {
            this.caseResults = new HashMap<String, RobotCaseResult>();
        }
        int i = 1;
        String checkedTestName = originalName = caseResult.getName();
        while (this.caseResults.get(checkedTestName) != null) {
            checkedTestName = originalName + "_" + i;
            ++i;
        }
        caseResult.setDuplicateSafeName(checkedTestName);
        this.caseResults.put(caseResult.getDuplicateSafeName(), caseResult);
    }

    public void setElapsedTime(String elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    @Override
    public long getDuration() {
        if (this.schemaVersion >= 5) {
            double d = Double.parseDouble(this.elapsedTime) * 1000.0;
            return Double.valueOf(d).longValue();
        }
        if (StringUtils.isNotEmpty((String)this.elapsedTime)) {
            return Long.parseLong(this.elapsedTime);
        }
        if (StringUtils.isEmpty((String)this.startTime) || StringUtils.isEmpty((String)this.endTime)) {
            return this.duration;
        }
        try {
            return RobotCaseResult.timeDifference(this.startTime, this.endTime);
        }
        catch (ParseException e) {
            LOGGER.warn((Object)("Couldn't parse duration for suite " + this.name));
            return 0L;
        }
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getSearchUrl() {
        return this.getDisplayName();
    }

    public RobotSuiteResult getSuite(String name) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(name);
    }

    public RobotCaseResult getCase(String name) {
        if (this.caseResults == null) {
            return null;
        }
        return this.caseResults.get(name);
    }

    @Override
    public RobotSuiteResult getPreviousResult() {
        if (this.parent == null) {
            return null;
        }
        RobotTestObject prevParent = this.parent.getPreviousResult();
        if (prevParent instanceof RobotSuiteResult) {
            RobotSuiteResult result = ((RobotSuiteResult)prevParent).getSuite(this.getDuplicateSafeName());
            if (result == null) {
                result = ((RobotSuiteResult)prevParent).getSuite(this.getOldFormatName());
            }
            return result;
        }
        if (prevParent instanceof RobotResult) {
            RobotSuiteResult result = ((RobotResult)prevParent).getSuite(this.getDuplicateSafeName());
            if (result == null) {
                result = ((RobotResult)prevParent).getSuite(this.getOldFormatName());
            }
            return result;
        }
        return null;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerRequest rsp) {
        if (token == null) {
            return this;
        }
        if (this.getCase(token) != null) {
            return this.getCase(token);
        }
        return this.getSuite(token);
    }

    public List<RobotSuiteResult> getAllChildSuites() {
        ArrayList<RobotSuiteResult> allChildSuites = new ArrayList<RobotSuiteResult>();
        for (RobotSuiteResult suite : this.getChildSuites()) {
            allChildSuites.add(suite);
            List<RobotSuiteResult> childSuites = suite.getAllChildSuites();
            allChildSuites.addAll(childSuites);
        }
        return allChildSuites;
    }

    public List<RobotCaseResult> getAllFailedCases() {
        ArrayList<RobotCaseResult> failedCases = new ArrayList<RobotCaseResult>();
        for (RobotCaseResult caseResult : this.getCaseResults()) {
            if (caseResult.isPassed() || caseResult.isSkipped()) continue;
            failedCases.add(caseResult);
        }
        for (RobotSuiteResult suite : this.getChildSuites()) {
            failedCases.addAll(suite.getAllFailedCases());
        }
        Collections.sort(failedCases, new RobotCaseComparator());
        return failedCases;
    }

    public List<RobotCaseResult> getAllPassedCases() {
        ArrayList<RobotCaseResult> passedCases = new ArrayList<RobotCaseResult>();
        for (RobotCaseResult caseResult : this.getCaseResults()) {
            if (!caseResult.isPassed()) continue;
            passedCases.add(caseResult);
        }
        for (RobotSuiteResult suite : this.getChildSuites()) {
            passedCases.addAll(suite.getAllPassedCases());
        }
        Collections.sort(passedCases, new RobotCaseComparator());
        return passedCases;
    }

    public List<RobotCaseResult> getAllSkippedCases() {
        ArrayList<RobotCaseResult> skippedCases = new ArrayList<RobotCaseResult>();
        for (RobotCaseResult caseResult : this.getCaseResults()) {
            if (!caseResult.isSkipped()) continue;
            skippedCases.add(caseResult);
        }
        for (RobotSuiteResult suite : this.getChildSuites()) {
            skippedCases.addAll(suite.getAllSkippedCases());
        }
        Collections.sort(skippedCases, new RobotCaseComparator());
        return skippedCases;
    }

    public List<RobotCaseResult> getAllCases() {
        ArrayList<RobotCaseResult> cases = new ArrayList<RobotCaseResult>();
        cases.addAll(this.getCaseResults());
        for (RobotSuiteResult suite : this.getChildSuites()) {
            cases.addAll(suite.getAllCases());
        }
        return cases;
    }

    public void failTeardown() {
        for (RobotCaseResult res : this.getAllCases()) {
            res.setPassed(false);
        }
    }

    public void tally(RobotBuildAction parentAction) {
        this.setParentAction(parentAction);
        this.failed = 0;
        this.passed = 0;
        this.skipped = 0;
        this.criticalPassed = 0;
        this.criticalFailed = 0;
        this.duration = 0L;
        HashMap<String, RobotCaseResult> newCases = new HashMap<String, RobotCaseResult>();
        for (RobotCaseResult caseResult : this.getCaseResults()) {
            if (caseResult.isPassed()) {
                if (caseResult.isCritical()) {
                    ++this.criticalPassed;
                }
                ++this.passed;
            } else if (caseResult.isSkipped()) {
                ++this.skipped;
            } else {
                if (caseResult.isCritical()) {
                    ++this.criticalFailed;
                }
                ++this.failed;
            }
            this.duration += caseResult.getDuration();
            caseResult.setParentAction(parentAction);
            newCases.put(caseResult.getDuplicateSafeName(), caseResult);
        }
        this.caseResults = newCases;
        HashMap<String, RobotSuiteResult> newSuites = new HashMap<String, RobotSuiteResult>();
        for (RobotSuiteResult suite : this.getChildSuites()) {
            suite.tally(parentAction);
            this.failed += suite.getFailed();
            this.passed += suite.getPassed();
            this.skipped += suite.getSkipped();
            this.criticalFailed = (int)((long)this.criticalFailed + suite.getCriticalFailed());
            this.criticalPassed = (int)((long)this.criticalPassed + suite.getCriticalPassed());
            this.duration += suite.getDuration();
            newSuites.put(suite.getDuplicateSafeName(), suite);
        }
        this.children = newSuites;
    }

    public RobotTestObject findObjectById(String id) {
        if (id.indexOf("/") >= 0) {
            String suiteName = id.substring(0, id.indexOf("/"));
            String childId = id.substring(id.indexOf("/") + 1, id.length());
            RobotSuiteResult suite = this.children.get(suiteName);
            return suite.findObjectById(childId);
        }
        if (this.getSuite(id) != null) {
            return this.getSuite(id);
        }
        return this.getCase(id);
    }

    public void addChildren(Collection<RobotSuiteResult> childSuites) {
        for (RobotSuiteResult child : childSuites) {
            this.addChild(child);
        }
    }

    public void addCaseResults(Collection<RobotCaseResult> newCaseResults) {
        for (RobotCaseResult caseResult : newCaseResults) {
            this.caseResults.putIfAbsent(caseResult.getDuplicateSafeName(), caseResult);
        }
    }
}

