/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot.graph;

import hudson.model.Run;
import hudson.plugins.robot.model.RobotTestObject;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RobotBuildLabel
implements Comparable<RobotBuildLabel> {
    private final Run<?, ?> run;
    private final String buildLabel;

    public RobotBuildLabel(RobotTestObject obj, String format) {
        this.run = obj.getOwner();
        this.buildLabel = this.formatBuildLabel(format, this.run.getTime());
    }

    private String formatBuildLabel(String format, Date startTime) {
        String pattern = format.replace("$build", "" + this.run.number);
        pattern = pattern.replace("$display_name", this.run.getDisplayName());
        return new SimpleDateFormat(pattern).format(startTime);
    }

    @Override
    public int compareTo(RobotBuildLabel that) {
        return this.run.number - that.run.number;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RobotBuildLabel)) {
            return false;
        }
        RobotBuildLabel that = (RobotBuildLabel)o;
        return this.run == that.run;
    }

    public int hashCode() {
        return this.run.hashCode();
    }

    public String toString() {
        return this.buildLabel;
    }
}

