/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.common;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import org.jenkins_ci.plugins.run_condition.common.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public abstract class BaseDirectory
implements Describable<BaseDirectory> {
    public abstract FilePath getBaseDirectory(AbstractBuild<?, ?> var1);

    public Descriptor<BaseDirectory> getDescriptor() {
        return Hudson.getInstance().getDescriptor(this.getClass());
    }

    public static class JenkinsHome
    extends BaseDirectory {
        @DataBoundConstructor
        public JenkinsHome() {
        }

        @Override
        public FilePath getBaseDirectory(AbstractBuild<?, ?> build) {
            return Hudson.getInstance().getRootPath();
        }

        @Extension(ordinal=-3.0)
        public static class JenkinsHomeDescriptor
        extends BaseDirectoryDescriptor {
            public String getDisplayName() {
                return Messages.baseDirectory_jenkinsHome_displayName();
            }
        }
    }

    public static class ArtifactsDir
    extends BaseDirectory {
        @DataBoundConstructor
        public ArtifactsDir() {
        }

        @Override
        public FilePath getBaseDirectory(AbstractBuild<?, ?> build) {
            return new FilePath(Hudson.getInstance().getRootPath(), build.getArtifactsDir().getAbsolutePath());
        }

        @Extension(ordinal=-2.0)
        public static class ArtifactsDirDescriptor
        extends BaseDirectoryDescriptor {
            public String getDisplayName() {
                return Messages.baseDirectory_artifacts_displayName();
            }
        }
    }

    public static class Workspace
    extends BaseDirectory {
        @DataBoundConstructor
        public Workspace() {
        }

        @Override
        public FilePath getBaseDirectory(AbstractBuild<?, ?> build) {
            return build.getWorkspace();
        }

        @Extension(ordinal=-1.0)
        public static class WorkspaceDescriptor
        extends BaseDirectoryDescriptor {
            public String getDisplayName() {
                return Messages.baseDirectory_workspace_displayName();
            }
        }
    }

    public static abstract class BaseDirectoryDescriptor
    extends Descriptor<BaseDirectory> {
    }
}

