/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.Extension;
import hudson.cli.BuildCommand;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import hudson.util.ListBoxModel;
import java.lang.reflect.Method;
import java.util.List;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.kohsuke.stapler.DataBoundConstructor;

public final class CauseCondition
extends AlwaysPrebuildRunCondition {
    private final BuildCause buildCause;
    private final boolean exclusiveCause;

    @DataBoundConstructor
    public CauseCondition(String buildCause, boolean exclusiveCause) {
        this.buildCause = BuildCause.valueOf(buildCause);
        this.exclusiveCause = exclusiveCause;
    }

    public BuildCause getBuildCause() {
        return this.buildCause;
    }

    public boolean isExclusiveCause() {
        return this.exclusiveCause;
    }

    @Override
    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) {
        String name = this.buildCause == null ? "N/A" : this.buildCause.displayName;
        listener.getLogger().println(Messages.causeCondition_check(name));
        List causes = build.getRootBuild().getCauses();
        if (this.buildCause != null) {
            if (this.isExclusiveCause()) {
                return causes.size() == 1 && this.buildCause.isCausedBy((Cause)causes.get(0));
            }
            for (Cause cause : causes) {
                if (!this.buildCause.isCausedBy(cause)) continue;
                return true;
            }
        }
        return false;
    }

    @Extension
    public static class CauseConditionDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return Messages.causeCondition_displayName();
        }

        public ListBoxModel doFillBuildCauseItems() {
            ListBoxModel items = new ListBoxModel();
            for (BuildCause cause : BuildCause.values()) {
                items.add((Object)new ListBoxModel.Option(cause.displayName, cause.name()));
            }
            return items;
        }
    }

    private static enum BuildCause {
        USER_CAUSE(Cause.UserCause.class, "UserCause"){

            @Override
            public boolean isCausedBy(Cause cause) {
                String className = cause.getClass().getName();
                return this.causeClassName.equals(className) || "hudson.model.Cause$UserIdCause".equals(className);
            }
        }
        ,
        M2_RELEASE_CAUSE("org.jvnet.hudson.plugins.m2release.ReleaseCause", "M2ReleaseCause"),
        CLI_CAUSE(BuildCommand.CLICause.class, "CLICause"),
        REMOTE_CAUSE(Cause.RemoteCause.class, "RemoteCause"),
        SCM_CAUSE(SCMTrigger.SCMTriggerCause.class, "SCMTrigger"),
        TIMER_CAUSE(TimerTrigger.TimerTriggerCause.class, "TimerTrigger"),
        UPSTREAM_CAUSE(Cause.UpstreamCause.class, "UpstreamCause"),
        FS_CAUSE("org.jenkinsci.lib.xtrigger.XTriggerCause", "FSTrigger"){

            @Override
            public boolean isCausedBy(Cause cause) {
                return BuildCause.isCauseByForXTrigger((BuildCause)this, cause);
            }
        }
        ,
        URL_CAUSE("org.jenkinsci.lib.xtrigger.XTriggerCause", "URLTrigger"){

            @Override
            public boolean isCausedBy(Cause cause) {
                return BuildCause.isCauseByForXTrigger((BuildCause)this, cause);
            }
        }
        ,
        IVY_CAUSE("org.jenkinsci.lib.xtrigger.XTriggerCause", "IvyTrigger"){

            @Override
            public boolean isCausedBy(Cause cause) {
                return BuildCause.isCauseByForXTrigger((BuildCause)this, cause);
            }
        }
        ,
        SCRIPT_CAUSE("org.jenkinsci.lib.xtrigger.XTriggerCause", "ScriptTrigger"){

            @Override
            public boolean isCausedBy(Cause cause) {
                return BuildCause.isCauseByForXTrigger((BuildCause)this, cause);
            }
        }
        ,
        BUILDRESULT_CAUSE("org.jenkinsci.lib.xtrigger.XTriggerCause", "BuildResultTrigger"){

            @Override
            public boolean isCausedBy(Cause cause) {
                return BuildCause.isCauseByForXTrigger((BuildCause)this, cause);
            }
        }
        ,
        NUGET_CAUSE("org.jenkinsci.lib.xtrigger.XTriggerCause", "NuGet"){

            @Override
            public boolean isCausedBy(Cause cause) {
                return BuildCause.isCauseByForXTrigger((BuildCause)this, cause);
            }
        };

        public final String causeClassName;
        public final String displayName;

        private BuildCause(String causeClassName, String displayName) {
            this.causeClassName = causeClassName;
            this.displayName = displayName;
        }

        boolean isCausedBy(Cause cause) {
            return this.causeClassName.equals(cause.getClass().getName());
        }

        private static boolean isCauseByForXTrigger(BuildCause buildCause, Cause cause) {
            try {
                Method method = cause.getClass().getDeclaredMethod("getTriggerName", new Class[0]);
                String triggerName = (String)method.invoke((Object)cause, new Object[0]);
                return buildCause.displayName.equals(triggerName);
            }
            catch (ReflectiveOperationException e) {
                return false;
            }
        }

        private BuildCause(Class<? extends Cause> clazz, String displayName) {
            this.causeClassName = clazz.getName();
            this.displayName = displayName;
        }
    }
}

