/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.util.List;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.jenkins_ci.plugins.run_condition.common.BaseDirectory;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public final class FileExistsCondition
extends AlwaysPrebuildRunCondition {
    final String file;
    final BaseDirectory baseDir;

    @DataBoundConstructor
    public FileExistsCondition(String file, BaseDirectory baseDir) {
        this.file = file;
        this.baseDir = baseDir;
    }

    public BaseDirectory getBaseDir() {
        return this.baseDir;
    }

    public String getFile() {
        return this.file;
    }

    @Override
    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        String expandedFile = TokenMacro.expandAll(build, (TaskListener)listener, (String)this.file);
        listener.getLogger().println(Messages.fileExistsCondition_check(expandedFile));
        return this.baseDir.getBaseDirectory(build).child(expandedFile).exists();
    }

    @Extension
    public static class FileExistsConditionDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return Messages.fileExistsCondition_displayName();
        }

        public List<? extends Descriptor<? extends BaseDirectory>> getBaseDirectories() {
            return Hudson.getInstance().getDescriptorList(BaseDirectory.class);
        }

        public FormValidation doCheckFile(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }
    }
}

