/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.ComputerSet;
import hudson.model.Executor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.common.AlwaysPrebuildRunCondition;
import org.kohsuke.stapler.DataBoundConstructor;

public final class NodeCondition
extends AlwaysPrebuildRunCondition {
    private static final String MASTER = "master";
    final List<String> allowedNodes;

    @DataBoundConstructor
    public NodeCondition(List<String> allowedNodes) {
        this.allowedNodes = allowedNodes;
    }

    public List<String> getAllowedNodes() {
        return this.allowedNodes == null ? Collections.emptyList() : this.allowedNodes;
    }

    @Override
    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) {
        Executor exec = build.getExecutor();
        if (exec == null) {
            return false;
        }
        String currentNode = exec.getOwner().getName();
        currentNode = "".equals(currentNode) ? MASTER : currentNode;
        listener.getLogger().println(Messages.nodeCondition_check(currentNode, Arrays.toString(this.getAllowedNodes().toArray())));
        return this.getAllowedNodes().contains(currentNode);
    }

    public static List<String> getNodeNamesForSelection() {
        List slaveNames = NodeConditionDescriptor.getSlaveNames();
        Collections.sort(slaveNames, NodeNameComparator.INSTANCE);
        return slaveNames;
    }

    @Extension
    public static class NodeConditionDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return Messages.nodeCondition_displayName();
        }

        private static List<String> getSlaveNames() {
            Jenkins j = Jenkins.getInstance();
            if (j == null) {
                return null;
            }
            ComputerSet computers = j.getComputer();
            List slaveNames = computers.get_slaveNames();
            ArrayList<String> test = new ArrayList<String>();
            test.addAll(slaveNames);
            if (!test.contains(NodeCondition.MASTER)) {
                test.add(0, NodeCondition.MASTER);
            }
            return test;
        }
    }

    private static final class NodeNameComparator
    implements Comparator<String> {
        public static final NodeNameComparator INSTANCE = new NodeNameComparator();

        private NodeNameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (NodeCondition.MASTER.endsWith(o1)) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    }
}

