/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.core;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.util.FormValidation;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class TimeCondition
extends RunCondition {
    private static final Pattern TIME = Pattern.compile("^((?:0?\\d)|(?:1\\d)|(?:2[0-3])):([0-5]\\d)$");
    private static final String TIME_STR_FORMAT = "%02d:%02d";
    private final int earliestHours;
    private final int earliestMinutes;
    private final int latestHours;
    private final int latestMinutes;
    private final boolean useBuildTime;

    @DataBoundConstructor
    public TimeCondition(String earliest, String latest, boolean useBuildTime) {
        Matcher earliestM = TIME.matcher(earliest);
        if (!earliestM.matches()) {
            throw new RuntimeException(Messages.timeCondition_validation_invalid(earliest));
        }
        Matcher latestM = TIME.matcher(latest);
        if (!latestM.matches()) {
            throw new RuntimeException(Messages.timeCondition_validation_invalid(latest));
        }
        this.earliestHours = Integer.parseInt(earliestM.group(1));
        this.earliestMinutes = Integer.parseInt(earliestM.group(2));
        this.latestHours = Integer.parseInt(latestM.group(1));
        this.latestMinutes = Integer.parseInt(latestM.group(2));
        this.useBuildTime = useBuildTime;
    }

    public int getEarliestHours() {
        return this.earliestHours;
    }

    public int getEarliestMinutes() {
        return this.earliestMinutes;
    }

    public int getLatestHours() {
        return this.latestHours;
    }

    public int getLatestMinutes() {
        return this.latestMinutes;
    }

    public boolean isUseBuildTime() {
        return this.useBuildTime;
    }

    public String getEarliest() {
        return String.format(TIME_STR_FORMAT, this.earliestHours, this.earliestMinutes);
    }

    public String getLatest() {
        return String.format(TIME_STR_FORMAT, this.latestHours, this.latestMinutes);
    }

    @Override
    public final boolean runPrebuild(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        return this.useBuildTime ? this.isInHours(this.getTimestamp(build), listener) : true;
    }

    @Override
    public final boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        return this.useBuildTime ? this.isInHours(this.getTimestamp(build), listener) : this.isInHours(this.getNow(), listener);
    }

    protected Calendar getNow() {
        return Calendar.getInstance();
    }

    protected Calendar getTimestamp(AbstractBuild<?, ?> build) {
        return build.getTimestamp();
    }

    private final boolean isInHours(Calendar testTime, BuildListener listener) {
        Calendar lower = (Calendar)testTime.clone();
        Calendar upper = (Calendar)lower.clone();
        TimeCondition.setTime(lower, this.earliestHours, this.earliestMinutes);
        TimeCondition.setTime(upper, this.latestHours, this.latestMinutes);
        TimeCondition.floor(lower);
        TimeCondition.floor(upper);
        lower.add(13, -1);
        upper.add(12, 1);
        String time = DateFormat.getTimeInstance(3).format(testTime.getTime());
        listener.getLogger().println(Messages.timeCondition_console_testing(this.getEarliest(), time, this.getLatest()));
        return lower.before(testTime) && upper.after(testTime);
    }

    private static void floor(Calendar calendar) {
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    private static void setTime(Calendar calendar, int hours, int minutes) {
        calendar.set(11, hours);
        calendar.set(12, minutes);
    }

    public static boolean isTimeValid(String time) {
        return TIME.matcher(time).matches();
    }

    @Extension
    public static class TimeConditionDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return Messages.timeCondition_displayName();
        }

        public FormValidation doCheckEarliest(@QueryParameter String value) {
            return this.checkTime(value);
        }

        public FormValidation doCheckLatest(@QueryParameter String value) {
            return this.checkTime(value);
        }

        private FormValidation checkTime(String time) {
            return TimeCondition.isTimeValid(time) ? FormValidation.ok() : FormValidation.error((String)Messages.timeCondition_validation_invalid(time));
        }
    }
}

