/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.logic;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import java.util.ArrayList;
import org.jenkins_ci.plugins.run_condition.Messages;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.logic.ConditionContainer;
import org.kohsuke.stapler.DataBoundConstructor;

public class Or
extends RunCondition {
    private final ArrayList<ConditionContainer> conditions;

    @DataBoundConstructor
    public Or(ArrayList<ConditionContainer> conditions) {
        this.conditions = conditions;
    }

    public ArrayList<ConditionContainer> getConditions() {
        return this.conditions;
    }

    @Override
    public boolean runPrebuild(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        for (ConditionContainer condition : this.conditions) {
            if (!condition.runPrebuild(build, listener)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean runPerform(AbstractBuild<?, ?> build, BuildListener listener) throws Exception {
        for (ConditionContainer condition : this.conditions) {
            if (!condition.runPerform(build, listener)) continue;
            return true;
        }
        return false;
    }

    @Extension(ordinal=-1000001.0)
    public static class OrDescriptor
    extends RunCondition.RunConditionDescriptor {
        public String getDisplayName() {
            return Messages.logic_or_displayName();
        }
    }
}

