/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import hudson.model.Item;
import java.io.Serializable;
import jenkins.model.Jenkins;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCMHead
implements Comparable<SCMHead>,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String name;

    public SCMHead(@NonNull String name) {
        name.getClass();
        this.name = name;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SCMHead scmHead = (SCMHead)o;
        return this.name.equals(scmHead.name);
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(SCMHead o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SCMHead{'");
        sb.append(this.name).append("'}");
        return sb.toString();
    }

    public static abstract class HeadByItem
    implements ExtensionPoint {
        @CheckForNull
        public abstract SCMHead getHead(Item var1);

        @CheckForNull
        public static SCMHead findHead(Item item) {
            Jenkins j = Jenkins.getInstance();
            if (j == null) {
                return null;
            }
            for (HeadByItem ext : j.getExtensionList(HeadByItem.class)) {
                SCMHead head = ext.getHead(item);
                if (head == null) continue;
                return head;
            }
            return null;
        }
    }
}

