/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api.trait;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.scm.SCM;
import java.util.Arrays;
import java.util.Collection;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.trait.SCMSourceTrait;

public abstract class SCMBuilder<B extends SCMBuilder<B, S>, S extends SCM> {
    @NonNull
    private final Class<S> clazz;
    @NonNull
    private SCMHead head;
    @CheckForNull
    private SCMRevision revision;

    public SCMBuilder(Class<S> clazz, @NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        this.clazz = clazz;
        this.head = head;
        this.revision = revision;
    }

    @NonNull
    public final SCMHead head() {
        return this.head;
    }

    @CheckForNull
    public final SCMRevision revision() {
        return this.revision;
    }

    @NonNull
    public final Class<S> scmClass() {
        return this.clazz;
    }

    @NonNull
    public final B withHead(@NonNull SCMHead head) {
        this.head = head;
        return (B)this;
    }

    @NonNull
    public final B withRevision(@CheckForNull SCMRevision revision) {
        this.revision = revision;
        return (B)this;
    }

    @NonNull
    public final B withTrait(@NonNull SCMSourceTrait trait) {
        trait.applyToBuilder(this);
        return (B)this;
    }

    @NonNull
    public final B withTraits(SCMSourceTrait ... traits) {
        return this.withTraits(Arrays.asList(traits));
    }

    @NonNull
    public final B withTraits(@NonNull Collection<SCMSourceTrait> traits) {
        for (SCMSourceTrait trait : traits) {
            this.withTrait(trait);
        }
        return (B)this;
    }

    @NonNull
    public abstract S build();
}

