/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api.trait;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMHeadFilter;
import jenkins.scm.api.trait.SCMHeadPrefilter;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;

public abstract class SCMSourceContext<C extends SCMSourceContext<C, R>, R extends SCMSourceRequest> {
    @NonNull
    private final List<SCMSourceCriteria> criteria = new ArrayList<SCMSourceCriteria>();
    @NonNull
    private final List<SCMHeadPrefilter> prefilters = new ArrayList<SCMHeadPrefilter>();
    @NonNull
    private final List<SCMHeadFilter> filters = new ArrayList<SCMHeadFilter>();
    @NonNull
    private final List<SCMHeadAuthority<?, ?, ?>> authorities = new ArrayList();
    @NonNull
    private SCMHeadObserver observer;

    public SCMSourceContext(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer) {
        this.withCriteria(criteria);
        this.observer = observer;
    }

    @NonNull
    public final List<SCMHeadAuthority<?, ?, ?>> authorities() {
        return Collections.unmodifiableList(this.authorities);
    }

    @NonNull
    public final List<SCMSourceCriteria> criteria() {
        return Collections.unmodifiableList(this.criteria);
    }

    @NonNull
    public final List<SCMHeadFilter> filters() {
        return Collections.unmodifiableList(this.filters);
    }

    @NonNull
    public final List<SCMHeadPrefilter> prefilters() {
        return Collections.unmodifiableList(this.prefilters);
    }

    @NonNull
    public final SCMHeadObserver observer() {
        return this.observer;
    }

    @NonNull
    public final C withAuthority(@CheckForNull SCMHeadAuthority authority) {
        if (authority != null) {
            this.authorities.add(authority);
        }
        return (C)this;
    }

    @NonNull
    public final C withCriteria(@CheckForNull SCMSourceCriteria criteria) {
        if (criteria != null) {
            this.criteria.add(criteria);
        }
        return (C)this;
    }

    @NonNull
    public final C withFilter(@CheckForNull SCMHeadFilter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return (C)this;
    }

    @NonNull
    public final C withPrefilter(@CheckForNull SCMHeadPrefilter prefilter) {
        if (prefilter != null) {
            this.prefilters.add(prefilter);
        }
        return (C)this;
    }

    @NonNull
    public final C withTrait(@NonNull SCMSourceTrait trait) {
        this.observer = trait.applyToObserver(this.observer);
        trait.applyToContext(this);
        return (C)this;
    }

    @NonNull
    public final C withTraits(SCMSourceTrait ... traits) {
        return this.withTraits(Arrays.asList(traits));
    }

    @NonNull
    public final C withTraits(@NonNull Collection<SCMSourceTrait> traits) {
        for (SCMSourceTrait trait : traits) {
            this.withTrait(trait);
        }
        return (C)this;
    }

    @NonNull
    public abstract R newRequest(@NonNull SCMSource var1, @CheckForNull TaskListener var2);
}

