/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox;

import hudson.ExtensionPoint;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.ProxyWhitelist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Whitelist
implements ExtensionPoint {
    private static final Map<Jenkins, Whitelist> allByJenkins = new WeakHashMap<Jenkins, Whitelist>();

    public abstract boolean permitsMethod(@Nonnull Method var1, @Nonnull Object var2, @Nonnull Object[] var3);

    public abstract boolean permitsConstructor(@Nonnull Constructor<?> var1, @Nonnull Object[] var2);

    public abstract boolean permitsStaticMethod(@Nonnull Method var1, @Nonnull Object[] var2);

    public abstract boolean permitsFieldGet(@Nonnull Field var1, @Nonnull Object var2);

    public abstract boolean permitsFieldSet(@Nonnull Field var1, @Nonnull Object var2, @CheckForNull Object var3);

    public abstract boolean permitsStaticFieldGet(@Nonnull Field var1);

    public abstract boolean permitsStaticFieldSet(@Nonnull Field var1, @CheckForNull Object var2);

    @Nonnull
    public static synchronized Whitelist all() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            return new ProxyWhitelist(new Whitelist[0]);
        }
        Whitelist all = allByJenkins.get(j);
        if (all == null) {
            all = new ProxyWhitelist((Collection<? extends Whitelist>)j.getExtensionList(Whitelist.class));
            allByJenkins.put(j, all);
        }
        return all;
    }
}

