/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists;

import hudson.Extension;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.AclAwareWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public final class AnnotatedWhitelist
extends AclAwareWhitelist {
    public AnnotatedWhitelist() {
        super(new Impl(false), new Impl(true));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Impl
    extends Whitelist {
        private final boolean restricted;

        Impl(boolean restricted) {
            this.restricted = restricted;
        }

        private boolean allowed(@Nonnull AccessibleObject o) {
            Whitelisted ann = o.getAnnotation(Whitelisted.class);
            if (ann == null) {
                return false;
            }
            return ann.restricted() == this.restricted;
        }

        @Override
        public boolean permitsMethod(Method method, Object receiver, Object[] args) {
            return this.allowed(method);
        }

        @Override
        public boolean permitsConstructor(Constructor<?> constructor, Object[] args) {
            return this.allowed(constructor);
        }

        @Override
        public boolean permitsStaticMethod(Method method, Object[] args) {
            return this.allowed(method);
        }

        @Override
        public boolean permitsFieldGet(Field field, Object receiver) {
            return this.allowed(field);
        }

        @Override
        public boolean permitsFieldSet(Field field, Object receiver, Object value) {
            return this.allowed(field);
        }

        @Override
        public boolean permitsStaticFieldGet(Field field) {
            return this.allowed(field);
        }

        @Override
        public boolean permitsStaticFieldSet(Field field, Object value) {
            return this.allowed(field);
        }
    }
}

