/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.EnumeratingWhitelist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticWhitelist
extends EnumeratingWhitelist {
    final List<EnumeratingWhitelist.MethodSignature> methodSignatures = new ArrayList<EnumeratingWhitelist.MethodSignature>();
    final List<EnumeratingWhitelist.NewSignature> newSignatures = new ArrayList<EnumeratingWhitelist.NewSignature>();
    final List<EnumeratingWhitelist.MethodSignature> staticMethodSignatures = new ArrayList<EnumeratingWhitelist.MethodSignature>();
    final List<EnumeratingWhitelist.FieldSignature> fieldSignatures = new ArrayList<EnumeratingWhitelist.FieldSignature>();
    final List<EnumeratingWhitelist.FieldSignature> staticFieldSignatures = new ArrayList<EnumeratingWhitelist.FieldSignature>();

    public StaticWhitelist(Reader definition) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(definition);
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            this.add(line);
        }
    }

    public StaticWhitelist(Collection<? extends String> lines) throws IOException {
        for (String string : lines) {
            this.add(string);
        }
    }

    public StaticWhitelist(String ... lines) throws IOException {
        this(Arrays.asList(lines));
    }

    private void add(String line) throws IOException {
        String[] toks = line.split(" ");
        if (toks[0].equals("method")) {
            if (toks.length < 3) {
                throw new IOException(line);
            }
            this.methodSignatures.add(new EnumeratingWhitelist.MethodSignature(toks[1], toks[2], StaticWhitelist.slice(toks, 3)));
        } else if (toks[0].equals("new")) {
            if (toks.length < 2) {
                throw new IOException(line);
            }
            this.newSignatures.add(new EnumeratingWhitelist.NewSignature(toks[1], StaticWhitelist.slice(toks, 2)));
        } else if (toks[0].equals("staticMethod")) {
            if (toks.length < 3) {
                throw new IOException(line);
            }
            this.staticMethodSignatures.add(new EnumeratingWhitelist.MethodSignature(toks[1], toks[2], StaticWhitelist.slice(toks, 3)));
        } else if (toks[0].equals("field")) {
            if (toks.length != 3) {
                throw new IOException(line);
            }
            this.fieldSignatures.add(new EnumeratingWhitelist.FieldSignature(toks[1], toks[2]));
        } else if (toks[0].equals("staticField")) {
            if (toks.length != 3) {
                throw new IOException(line);
            }
            this.staticFieldSignatures.add(new EnumeratingWhitelist.FieldSignature(toks[1], toks[2]));
        } else {
            throw new IOException(line);
        }
    }

    private static String[] slice(String[] toks, int from) {
        String[] r = new String[toks.length - from];
        System.arraycopy(toks, from, r, 0, toks.length - from);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Whitelist from(URL definition) throws IOException {
        InputStream is = definition.openStream();
        try {
            StaticWhitelist staticWhitelist = new StaticWhitelist(new InputStreamReader(is, "UTF-8"));
            return staticWhitelist;
        }
        finally {
            is.close();
        }
    }

    @Override
    protected List<EnumeratingWhitelist.MethodSignature> methodSignatures() {
        return this.methodSignatures;
    }

    @Override
    protected List<EnumeratingWhitelist.NewSignature> newSignatures() {
        return this.newSignatures;
    }

    @Override
    protected List<EnumeratingWhitelist.MethodSignature> staticMethodSignatures() {
        return this.staticMethodSignatures;
    }

    @Override
    protected List<EnumeratingWhitelist.FieldSignature> fieldSignatures() {
        return this.fieldSignatures;
    }

    @Override
    protected List<EnumeratingWhitelist.FieldSignature> staticFieldSignatures() {
        return this.staticFieldSignatures;
    }

    public static RejectedAccessException rejectMethod(@Nonnull Method m) {
        assert ((m.getModifiers() & 8) == 0);
        return new RejectedAccessException("method", EnumeratingWhitelist.getName(m.getDeclaringClass()) + " " + m.getName() + StaticWhitelist.printArgumentTypes(m.getParameterTypes()));
    }

    public static RejectedAccessException rejectMethod(@Nonnull Method m, String info) {
        assert ((m.getModifiers() & 8) == 0);
        return new RejectedAccessException("method", EnumeratingWhitelist.getName(m.getDeclaringClass()) + " " + m.getName() + StaticWhitelist.printArgumentTypes(m.getParameterTypes()), info);
    }

    public static RejectedAccessException rejectNew(@Nonnull Constructor<?> c) {
        return new RejectedAccessException("new", EnumeratingWhitelist.getName(c.getDeclaringClass()) + StaticWhitelist.printArgumentTypes(c.getParameterTypes()));
    }

    public static RejectedAccessException rejectStaticMethod(@Nonnull Method m) {
        assert ((m.getModifiers() & 8) != 0);
        return new RejectedAccessException("staticMethod", EnumeratingWhitelist.getName(m.getDeclaringClass()) + " " + m.getName() + StaticWhitelist.printArgumentTypes(m.getParameterTypes()));
    }

    public static RejectedAccessException rejectField(@Nonnull Field f) {
        assert ((f.getModifiers() & 8) == 0);
        return new RejectedAccessException("field", EnumeratingWhitelist.getName(f.getDeclaringClass()) + " " + f.getName());
    }

    public static RejectedAccessException rejectStaticField(@Nonnull Field f) {
        assert ((f.getModifiers() & 8) != 0);
        return new RejectedAccessException("staticField", EnumeratingWhitelist.getName(f.getDeclaringClass()) + " " + f.getName());
    }

    private static String printArgumentTypes(Class<?>[] parameterTypes) {
        StringBuilder b = new StringBuilder();
        for (Class<?> c : parameterTypes) {
            b.append(' ');
            b.append(EnumeratingWhitelist.getName(c));
        }
        return b.toString();
    }
}

