/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.grape.GrabAnnotationTransformation;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import hudson.util.FormValidation;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.ClassLoaderWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.Messages;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.RejectASTTransformsCustomizer;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SandboxInterceptor;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SandboxResolvingClassLoader;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.ProxyWhitelist;
import org.kohsuke.groovy.sandbox.SandboxTransformer;

public class GroovySandbox {
    public static final Logger LOGGER = Logger.getLogger(GroovySandbox.class.getName());

    @Nonnull
    public static CompilerConfiguration createSecureCompilerConfiguration() {
        CompilerConfiguration cc = GroovySandbox.createBaseCompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
        return cc;
    }

    @Nonnull
    public static CompilerConfiguration createBaseCompilerConfiguration() {
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new RejectASTTransformsCustomizer()});
        cc.setDisabledGlobalASTTransformations(new HashSet<String>(Collections.singletonList(GrabAnnotationTransformation.class.getName())));
        return cc;
    }

    @Nonnull
    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Should be managed by the caller.")
    public static ClassLoader createSecureClassLoader(ClassLoader base) {
        return new SandboxResolvingClassLoader(base);
    }

    public static void runInSandbox(@Nonnull Runnable r, @Nonnull Whitelist whitelist) throws RejectedAccessException {
        SandboxInterceptor sandbox = new SandboxInterceptor(whitelist);
        sandbox.register();
        try {
            r.run();
        }
        finally {
            sandbox.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V runInSandbox(@Nonnull Callable<V> c, @Nonnull Whitelist whitelist) throws Exception {
        SandboxInterceptor sandbox = new SandboxInterceptor(whitelist);
        sandbox.register();
        try {
            V v = c.call();
            return v;
        }
        finally {
            sandbox.unregister();
        }
    }

    @Deprecated
    public static void runInSandbox(final @Nonnull Script script, @Nonnull Whitelist whitelist) throws RejectedAccessException {
        GroovySandbox.runInSandbox(new Runnable(){

            @Override
            public void run() {
                script.run();
            }
        }, whitelist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Object run(@Nonnull Script script, @Nonnull Whitelist whitelist) throws RejectedAccessException {
        LOGGER.log(Level.WARNING, null, new IllegalStateException(Messages.GroovySandbox_useOfInsecureRunOverload()));
        ProxyWhitelist wrapperWhitelist = new ProxyWhitelist(new ClassLoaderWhitelist(script.getClass().getClassLoader()), whitelist);
        SandboxInterceptor sandbox = new SandboxInterceptor(wrapperWhitelist);
        sandbox.register();
        try {
            Object object = script.run();
            return object;
        }
        finally {
            sandbox.unregister();
        }
    }

    public static Object run(final @Nonnull GroovyShell shell, final @Nonnull String script, @Nonnull Whitelist whitelist) throws RejectedAccessException {
        try {
            final Script s = GroovySandbox.runInSandbox(new Callable<Script>(){

                @Override
                public Script call() throws Exception {
                    return shell.parse(script);
                }
            }, whitelist);
            return GroovySandbox.runInSandbox(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return s.run();
                }
            }, (Whitelist)new ProxyWhitelist(new ClassLoaderWhitelist(s.getClass().getClassLoader()), whitelist));
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new AssertionError((Object)x);
        }
    }

    @Nonnull
    public static FormValidation checkScriptForCompilationErrors(String script, GroovyClassLoader classLoader) {
        try {
            CompilationUnit cu = new CompilationUnit(GroovySandbox.createSecureCompilerConfiguration(), new CodeSource(new URL("file", "", "/groovy/shell"), (Certificate[])null), classLoader);
            cu.addSource("Script1", script);
            cu.compile(5);
        }
        catch (MalformedURLException | CompilationFailedException e) {
            return FormValidation.error((String)e.getLocalizedMessage());
        }
        return FormValidation.ok();
    }

    private GroovySandbox() {
    }
}

