/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists;

import hudson.security.ACL;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.EnumeratingWhitelist;

public class AclAwareWhitelist
extends Whitelist {
    private final Whitelist unrestricted;
    private final Whitelist restricted;

    public AclAwareWhitelist(Whitelist unrestricted, Whitelist restricted) {
        this.unrestricted = unrestricted;
        if (this.unrestricted instanceof EnumeratingWhitelist) {
            ((EnumeratingWhitelist)this.unrestricted).precache();
        }
        this.restricted = restricted;
    }

    private static boolean authenticated() {
        return !ACL.SYSTEM.equals(Jenkins.getAuthentication());
    }

    @Override
    public boolean permitsMethod(Method method, Object receiver, Object[] args) {
        return this.unrestricted.permitsMethod(method, receiver, args) || AclAwareWhitelist.authenticated() && this.restricted.permitsMethod(method, receiver, args);
    }

    @Override
    public boolean permitsConstructor(Constructor<?> constructor, Object[] args) {
        return this.unrestricted.permitsConstructor(constructor, args) || AclAwareWhitelist.authenticated() && this.restricted.permitsConstructor(constructor, args);
    }

    @Override
    public boolean permitsStaticMethod(Method method, Object[] args) {
        return this.unrestricted.permitsStaticMethod(method, args) || AclAwareWhitelist.authenticated() && this.restricted.permitsStaticMethod(method, args);
    }

    @Override
    public boolean permitsFieldGet(Field field, Object receiver) {
        return this.unrestricted.permitsFieldGet(field, receiver);
    }

    @Override
    public boolean permitsFieldSet(Field field, Object receiver, Object value) {
        return this.unrestricted.permitsFieldSet(field, receiver, value);
    }

    @Override
    public boolean permitsStaticFieldGet(Field field) {
        return this.unrestricted.permitsStaticFieldGet(field);
    }

    @Override
    public boolean permitsStaticFieldSet(Field field, Object value) {
        return this.unrestricted.permitsStaticFieldSet(field, value);
    }
}

