/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaMethod;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import hudson.Functions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.runtime.DateGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.SqlGroovyMethods;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.SwingGroovyMethods;
import org.codehaus.groovy.runtime.XmlGroovyMethods;
import org.codehaus.groovy.runtime.metaclass.ClosureMetaMethod;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovyCallSiteSelector;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.EnumeratingWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.StaticWhitelist;
import org.kohsuke.groovy.sandbox.GroovyInterceptor;

final class SandboxInterceptor
extends GroovyInterceptor {
    private static final Logger LOGGER = Logger.getLogger(SandboxInterceptor.class.getName());
    private final Whitelist whitelist;
    private static final Class<?>[] DGM_CLASSES = new Class[]{DefaultGroovyMethods.class, StringGroovyMethods.class, SwingGroovyMethods.class, SqlGroovyMethods.class, XmlGroovyMethods.class, EncodingGroovyMethods.class, DateGroovyMethods.class, ProcessGroovyMethods.class};
    private static final Set<String> NUMBER_MATH_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("plus", "minus", "multiply", "div", "compareTo", "or", "and", "xor", "intdiv", "mod", "leftShift", "rightShift", "rightShiftUnsigned")));

    SandboxInterceptor(Whitelist whitelist) {
        this.whitelist = whitelist;
    }

    public Object onMethodCall(GroovyInterceptor.Invoker invoker, Object receiver, String method, Object ... args) throws Throwable {
        Method m = GroovyCallSiteSelector.method(receiver, method, args);
        if (m == null) {
            Object var;
            Script s22;
            Object element;
            if (receiver instanceof Number && NUMBER_MATH_NAMES.contains(method)) {
                return super.onMethodCall(invoker, receiver, method, args);
            }
            Object[] selfArgs = new Object[args.length + 1];
            selfArgs[0] = receiver;
            System.arraycopy(args, 0, selfArgs, 1, args.length);
            Method foundDgmMethod = null;
            for (Class<?> dgmClass : DGM_CLASSES) {
                Method dgmMethod = GroovyCallSiteSelector.staticMethod(dgmClass, method, selfArgs);
                if (dgmMethod == null) continue;
                if (this.whitelist.permitsStaticMethod(dgmMethod, selfArgs)) {
                    return super.onMethodCall(invoker, receiver, method, args);
                }
                if (foundDgmMethod != null) continue;
                foundDgmMethod = dgmMethod;
            }
            if (foundDgmMethod != null) {
                throw StaticWhitelist.rejectStaticMethod(foundDgmMethod);
            }
            if (receiver instanceof Map && (element = this.onMethodCall(invoker, receiver, "get", method)) instanceof Closure) {
                return this.onMethodCall(invoker, element, "call", args);
            }
            if (receiver instanceof Script && (s22 = (Script)receiver).getBinding().hasVariable(method) && !InvokerHelper.getMetaClass((Object)(var = s22.getBinding().getVariable(method))).respondsTo(var, "call", args).isEmpty()) {
                return this.onMethodCall(invoker, var, "call", args);
            }
            try {
                receiver.getClass().getMethod("invokeMethod", String.class, Object.class);
                return this.onMethodCall(invoker, receiver, "invokeMethod", method, args);
            }
            catch (NoSuchMethodException s22) {
                MetaMethod metaMethod = SandboxInterceptor.findMetaMethod(receiver, method, args);
                if (metaMethod instanceof ClosureMetaMethod) {
                    return super.onMethodCall(invoker, receiver, method, args);
                }
                throw new MissingMethodException(method, receiver.getClass(), args);
            }
        }
        if (StaticWhitelist.isPermanentlyBlacklistedMethod(m)) {
            throw StaticWhitelist.rejectMethod(m);
        }
        if (this.whitelist.permitsMethod(m, receiver, args)) {
            return super.onMethodCall(invoker, receiver, method, args);
        }
        if (method.equals("invokeMethod") && args.length == 2 && args[0] instanceof String && args[1] instanceof Object[]) {
            throw StaticWhitelist.rejectMethod(m, EnumeratingWhitelist.getName(receiver.getClass()) + " " + args[0] + SandboxInterceptor.printArgumentTypes((Object[])args[1]));
        }
        throw StaticWhitelist.rejectMethod(m);
    }

    public Object onNewInstance(GroovyInterceptor.Invoker invoker, Class receiver, Object ... args) throws Throwable {
        Constructor<?> c = GroovyCallSiteSelector.constructor(receiver, args);
        if (c == null) {
            throw new RejectedAccessException("No such constructor found: new " + EnumeratingWhitelist.getName(receiver) + SandboxInterceptor.printArgumentTypes(args));
        }
        if (StaticWhitelist.isPermanentlyBlacklistedConstructor(c)) {
            throw StaticWhitelist.rejectNew(c);
        }
        if (this.whitelist.permitsConstructor(c, args)) {
            return super.onNewInstance(invoker, receiver, args);
        }
        throw StaticWhitelist.rejectNew(c);
    }

    public Object onStaticCall(GroovyInterceptor.Invoker invoker, Class receiver, String method, Object ... args) throws Throwable {
        Method m = GroovyCallSiteSelector.staticMethod(receiver, method, args);
        if (m == null) {
            throw new RejectedAccessException("No such static method found: staticMethod " + EnumeratingWhitelist.getName(receiver) + " " + method + SandboxInterceptor.printArgumentTypes(args));
        }
        if (StaticWhitelist.isPermanentlyBlacklistedStaticMethod(m)) {
            throw StaticWhitelist.rejectStaticMethod(m);
        }
        if (this.whitelist.permitsStaticMethod(m, args)) {
            return super.onStaticCall(invoker, receiver, method, args);
        }
        throw StaticWhitelist.rejectStaticMethod(m);
    }

    public Object onSetProperty(GroovyInterceptor.Invoker invoker, final Object receiver, final String property, Object value) throws Throwable {
        Field instanceField;
        Object[] propertyValueArgs;
        Method setPropertyMethod;
        if (receiver instanceof Script && !property.equals("binding") && !property.equals("metaClass")) {
            return super.onSetProperty(invoker, receiver, property, value);
        }
        Rejector rejector = null;
        Object[] valueArg = new Object[]{value};
        String setter = "set" + Functions.capitalize((String)property);
        final Method setterMethod = GroovyCallSiteSelector.method(receiver, setter, valueArg);
        if (setterMethod != null) {
            if (this.whitelist.permitsMethod(setterMethod, receiver, valueArg)) {
                return super.onSetProperty(invoker, receiver, property, value);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectMethod(setterMethod);
                    }
                };
            }
        }
        if ((setPropertyMethod = GroovyCallSiteSelector.method(receiver, "setProperty", propertyValueArgs = new Object[]{property, value})) != null) {
            if (this.whitelist.permitsMethod(setPropertyMethod, receiver, propertyValueArgs)) {
                return super.onSetProperty(invoker, receiver, property, value);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectMethod(setPropertyMethod, receiver.getClass().getName() + "." + property);
                    }
                };
            }
        }
        if ((instanceField = GroovyCallSiteSelector.field(receiver, property)) != null) {
            if (this.whitelist.permitsFieldSet(instanceField, receiver, value)) {
                return super.onSetProperty(invoker, receiver, property, value);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectField(instanceField);
                    }
                };
            }
        }
        if (receiver instanceof Class) {
            Field staticField;
            final Method staticSetterMethod = GroovyCallSiteSelector.staticMethod((Class)receiver, setter, valueArg);
            if (staticSetterMethod != null) {
                if (this.whitelist.permitsStaticMethod(staticSetterMethod, valueArg)) {
                    return super.onSetProperty(invoker, receiver, property, value);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticMethod(staticSetterMethod);
                        }
                    };
                }
            }
            if ((staticField = GroovyCallSiteSelector.staticField((Class)receiver, property)) != null) {
                if (this.whitelist.permitsStaticFieldSet(staticField, value)) {
                    return super.onSetProperty(invoker, receiver, property, value);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticField(staticField);
                        }
                    };
                }
            }
        }
        throw rejector != null ? rejector.reject() : SandboxInterceptor.unclassifiedField(receiver, property);
    }

    public Object onGetProperty(GroovyInterceptor.Invoker invoker, final Object receiver, final String property) throws Throwable {
        MetaMethod metaMethod;
        Object[] propertyArg;
        Method getPropertyMethod;
        String booleanGetter;
        Method booleanGetterMethod;
        MissingPropertyException mpe = null;
        if (receiver instanceof Script) {
            try {
                ((Script)receiver).getBinding().getVariable(property);
                return super.onGetProperty(invoker, receiver, property);
            }
            catch (MissingPropertyException x) {
                mpe = x;
            }
        }
        if (property.equals("length") && receiver.getClass().isArray()) {
            return super.onGetProperty(invoker, receiver, property);
        }
        Rejector rejector = null;
        Object[] noArgs = new Object[]{};
        String getter = "get" + Functions.capitalize((String)property);
        final Method getterMethod = GroovyCallSiteSelector.method(receiver, getter, noArgs);
        if (getterMethod != null) {
            if (this.whitelist.permitsMethod(getterMethod, receiver, noArgs)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectMethod(getterMethod);
                    }
                };
            }
        }
        if ((booleanGetterMethod = GroovyCallSiteSelector.method(receiver, booleanGetter = "is" + Functions.capitalize((String)property), noArgs)) != null && booleanGetterMethod.getReturnType() == Boolean.TYPE) {
            if (this.whitelist.permitsMethod(booleanGetterMethod, receiver, noArgs)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectMethod(booleanGetterMethod);
                    }
                };
            }
        }
        Object[] selfArgs = new Object[]{receiver};
        for (Class<?> dgmClass : DGM_CLASSES) {
            Method dgmBooleanGetterMethod;
            final Method dgmGetterMethod = GroovyCallSiteSelector.staticMethod(dgmClass, getter, selfArgs);
            if (dgmGetterMethod != null) {
                if (this.whitelist.permitsStaticMethod(dgmGetterMethod, selfArgs)) {
                    return super.onGetProperty(invoker, receiver, property);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticMethod(dgmGetterMethod);
                        }
                    };
                }
            }
            if ((dgmBooleanGetterMethod = GroovyCallSiteSelector.staticMethod(dgmClass, booleanGetter, selfArgs)) == null || dgmBooleanGetterMethod.getReturnType() != Boolean.TYPE) continue;
            if (this.whitelist.permitsStaticMethod(dgmBooleanGetterMethod, selfArgs)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector != null) continue;
            rejector = new Rejector(){

                @Override
                public RejectedAccessException reject() {
                    return StaticWhitelist.rejectStaticMethod(dgmBooleanGetterMethod);
                }
            };
        }
        final Field instanceField = GroovyCallSiteSelector.field(receiver, property);
        if (instanceField != null) {
            if (this.whitelist.permitsFieldGet(instanceField, receiver)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectField(instanceField);
                    }
                };
            }
        }
        if ((getPropertyMethod = GroovyCallSiteSelector.method(receiver, "getProperty", propertyArg = new Object[]{property})) != null) {
            if (this.whitelist.permitsMethod(getPropertyMethod, receiver, propertyArg)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectMethod(getPropertyMethod, receiver.getClass().getName() + "." + property);
                    }
                };
            }
        }
        if ((metaMethod = SandboxInterceptor.findMetaMethod(receiver, getter, noArgs)) instanceof ClosureMetaMethod) {
            return super.onGetProperty(invoker, receiver, property);
        }
        if (receiver instanceof Class) {
            Field staticField;
            Method staticBooleanGetterMethod;
            final Method staticGetterMethod = GroovyCallSiteSelector.staticMethod((Class)receiver, getter, noArgs);
            if (staticGetterMethod != null) {
                if (this.whitelist.permitsStaticMethod(staticGetterMethod, noArgs)) {
                    return super.onGetProperty(invoker, receiver, property);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticMethod(staticGetterMethod);
                        }
                    };
                }
            }
            if ((staticBooleanGetterMethod = GroovyCallSiteSelector.staticMethod((Class)receiver, booleanGetter, noArgs)) != null && staticBooleanGetterMethod.getReturnType() == Boolean.TYPE) {
                if (this.whitelist.permitsStaticMethod(staticBooleanGetterMethod, noArgs)) {
                    return super.onGetProperty(invoker, receiver, property);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticMethod(staticBooleanGetterMethod);
                        }
                    };
                }
            }
            if ((staticField = GroovyCallSiteSelector.staticField((Class)receiver, property)) != null) {
                if (this.whitelist.permitsStaticFieldGet(staticField)) {
                    return super.onGetProperty(invoker, receiver, property);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticField(staticField);
                        }
                    };
                }
            }
        }
        if (mpe != null) {
            throw mpe;
        }
        throw rejector != null ? rejector.reject() : SandboxInterceptor.unclassifiedField(receiver, property);
    }

    public Object onSuperCall(GroovyInterceptor.Invoker invoker, Class senderType, Object receiver, String method, Object ... args) throws Throwable {
        Method m = GroovyCallSiteSelector.method(receiver, method, args);
        if (m == null) {
            throw new RejectedAccessException("No such method found: super.method " + EnumeratingWhitelist.getName(receiver.getClass()) + " " + method + SandboxInterceptor.printArgumentTypes(args));
        }
        if (this.whitelist.permitsMethod(m, receiver, args)) {
            return super.onSuperCall(invoker, senderType, receiver, method, args);
        }
        throw StaticWhitelist.rejectMethod(m);
    }

    private static RejectedAccessException unclassifiedField(Object receiver, String property) {
        return new RejectedAccessException("No such field found: field " + EnumeratingWhitelist.getName(receiver.getClass()) + " " + property);
    }

    public Object onGetAttribute(GroovyInterceptor.Invoker invoker, Object receiver, String attribute) throws Throwable {
        Field field = GroovyCallSiteSelector.field(receiver, attribute);
        if (field == null) {
            throw SandboxInterceptor.unclassifiedField(receiver, attribute);
        }
        if (this.whitelist.permitsFieldGet(field, receiver)) {
            return super.onGetAttribute(invoker, receiver, attribute);
        }
        throw StaticWhitelist.rejectField(field);
    }

    public Object onSetAttribute(GroovyInterceptor.Invoker invoker, Object receiver, String attribute, Object value) throws Throwable {
        Field field = GroovyCallSiteSelector.field(receiver, attribute);
        if (field == null) {
            throw SandboxInterceptor.unclassifiedField(receiver, attribute);
        }
        if (this.whitelist.permitsFieldSet(field, receiver, value)) {
            return super.onSetAttribute(invoker, receiver, attribute, value);
        }
        throw StaticWhitelist.rejectField(field);
    }

    public Object onGetArray(GroovyInterceptor.Invoker invoker, Object receiver, Object index) throws Throwable {
        if (receiver.getClass().isArray() && index instanceof Integer) {
            return super.onGetArray(invoker, receiver, index);
        }
        Object[] args = new Object[]{index};
        Method method = GroovyCallSiteSelector.method(receiver, "getAt", args);
        if (method != null) {
            if (this.whitelist.permitsMethod(method, receiver, args)) {
                return super.onGetArray(invoker, receiver, index);
            }
            throw StaticWhitelist.rejectMethod(method);
        }
        args = new Object[]{receiver, index};
        for (Class<?> dgm : DGM_CLASSES) {
            method = GroovyCallSiteSelector.staticMethod(dgm, "getAt", args);
            if (method == null) continue;
            if (this.whitelist.permitsStaticMethod(method, args)) {
                return super.onGetArray(invoker, receiver, index);
            }
            throw StaticWhitelist.rejectStaticMethod(method);
        }
        throw new RejectedAccessException("No such getAt method found: method " + EnumeratingWhitelist.getName(receiver) + "[" + EnumeratingWhitelist.getName(index) + "]");
    }

    public Object onSetArray(GroovyInterceptor.Invoker invoker, Object receiver, Object index, Object value) throws Throwable {
        if (receiver.getClass().isArray() && index instanceof Integer) {
            return super.onSetArray(invoker, receiver, index, value);
        }
        Object[] args = new Object[]{index, value};
        Method method = GroovyCallSiteSelector.method(receiver, "putAt", args);
        if (method != null) {
            if (this.whitelist.permitsMethod(method, receiver, args)) {
                return super.onSetArray(invoker, receiver, index, value);
            }
            throw StaticWhitelist.rejectMethod(method);
        }
        args = new Object[]{receiver, index, value};
        for (Class<?> dgm : DGM_CLASSES) {
            method = GroovyCallSiteSelector.staticMethod(dgm, "putAt", args);
            if (method == null) continue;
            if (this.whitelist.permitsStaticMethod(method, args)) {
                return super.onSetArray(invoker, receiver, index, value);
            }
            throw StaticWhitelist.rejectStaticMethod(method);
        }
        throw new RejectedAccessException("No such putAt method found: putAt method " + EnumeratingWhitelist.getName(receiver) + "[" + EnumeratingWhitelist.getName(index) + "]=" + EnumeratingWhitelist.getName(value));
    }

    private static String printArgumentTypes(Object[] args) {
        StringBuilder b = new StringBuilder();
        for (Object arg : args) {
            b.append(' ');
            b.append(EnumeratingWhitelist.getName(arg));
        }
        return b.toString();
    }

    @CheckForNull
    private static MetaMethod findMetaMethod(@NonNull Object receiver, @NonNull String method, @NonNull Object[] args) {
        Object[] types = new Class[args.length];
        for (int i = 0; i < types.length; ++i) {
            Object arg = args[i];
            types[i] = arg == null ? Void.TYPE : arg.getClass();
        }
        try {
            return DefaultGroovyMethods.getMetaClass((Object)receiver).pickMethod(method, (Class[])types);
        }
        catch (GroovyRuntimeException x) {
            LOGGER.log(Level.FINE, "could not find metamethod for " + receiver.getClass() + "." + method + Arrays.toString(types), x);
            return null;
        }
    }

    private static interface Rejector {
        @NonNull
        public RejectedAccessException reject();
    }
}

