/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaMethod;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.runtime.DateGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.SqlGroovyMethods;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.SwingGroovyMethods;
import org.codehaus.groovy.runtime.XmlGroovyMethods;
import org.codehaus.groovy.runtime.metaclass.ClosureMetaMethod;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovyCallSiteSelector;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.EnumeratingWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.StaticWhitelist;
import org.kohsuke.groovy.sandbox.GroovyInterceptor;
import org.kohsuke.groovy.sandbox.impl.Checker;

final class SandboxInterceptor
extends GroovyInterceptor {
    private static final Logger LOGGER = Logger.getLogger(SandboxInterceptor.class.getName());
    private final Whitelist whitelist;
    private static final Class<?>[] DGM_CLASSES = new Class[]{DefaultGroovyMethods.class, StringGroovyMethods.class, SwingGroovyMethods.class, SqlGroovyMethods.class, XmlGroovyMethods.class, EncodingGroovyMethods.class, DateGroovyMethods.class, ProcessGroovyMethods.class};
    private static final Set<String> NUMBER_MATH_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("plus", "minus", "multiply", "div", "compareTo", "or", "and", "xor", "intdiv", "mod", "leftShift", "rightShift", "rightShiftUnsigned")));

    SandboxInterceptor(Whitelist whitelist) {
        this.whitelist = whitelist;
    }

    public Object onMethodCall(GroovyInterceptor.Invoker invoker, Object receiver, String method, Object ... args) throws Throwable {
        Method m = GroovyCallSiteSelector.method(receiver, method, args);
        if (m == null) {
            Object var;
            Script s2;
            Object element;
            if (receiver instanceof Number && NUMBER_MATH_NAMES.contains(method)) {
                return super.onMethodCall(invoker, receiver, method, args);
            }
            Object[] selfArgs = new Object[args.length + 1];
            selfArgs[0] = receiver;
            System.arraycopy(args, 0, selfArgs, 1, args.length);
            Method foundDgmMethod = null;
            for (Class<?> dgmClass : DGM_CLASSES) {
                Method dgmMethod = GroovyCallSiteSelector.staticMethod(dgmClass, method, selfArgs);
                if (dgmMethod == null) continue;
                if (this.whitelist.permitsStaticMethod(dgmMethod, selfArgs)) {
                    return super.onMethodCall(invoker, receiver, method, args);
                }
                if (foundDgmMethod != null) continue;
                foundDgmMethod = dgmMethod;
            }
            if (foundDgmMethod != null) {
                throw StaticWhitelist.rejectStaticMethod(foundDgmMethod);
            }
            if (receiver instanceof Map && (element = this.onMethodCall(invoker, receiver, "get", method)) instanceof Closure) {
                return this.onMethodCall(invoker, element, "call", args);
            }
            if (receiver instanceof Script && (s2 = (Script)receiver).getBinding().hasVariable(method) && !InvokerHelper.getMetaClass((Object)(var = s2.getBinding().getVariable(method))).respondsTo(var, "call", args).isEmpty()) {
                return this.onMethodCall(invoker, var, "call", args);
            }
            try {
                receiver.getClass().getMethod("invokeMethod", String.class, Object.class);
                return this.onMethodCall(invoker, receiver, "invokeMethod", method, args);
            }
            catch (NoSuchMethodException s2) {
                MetaMethod metaMethod = SandboxInterceptor.findMetaMethod(receiver, method, args);
                if (metaMethod instanceof ClosureMetaMethod) {
                    return super.onMethodCall(invoker, receiver, method, args);
                }
                throw new MissingMethodException(method, receiver.getClass(), args);
            }
        }
        if (StaticWhitelist.isPermanentlyBlacklistedMethod(m)) {
            throw StaticWhitelist.rejectMethod(m);
        }
        if (SandboxInterceptor.permitsMethod(this.whitelist, m, receiver, args)) {
            return super.onMethodCall(invoker, receiver, method, args);
        }
        if (method.equals("invokeMethod") && args.length == 2 && args[0] instanceof String && args[1] instanceof Object[]) {
            throw StaticWhitelist.rejectMethod(m, EnumeratingWhitelist.getName(receiver.getClass()) + " " + String.valueOf(args[0]) + SandboxInterceptor.printArgumentTypes((Object[])args[1]));
        }
        throw SandboxInterceptor.rejectMethod(m);
    }

    public Object onNewInstance(GroovyInterceptor.Invoker invoker, Class receiver, Object ... args) throws Throwable {
        Constructor<?> c = GroovyCallSiteSelector.constructor(receiver, args);
        if (c == null) {
            throw new RejectedAccessException("No such constructor found: new " + EnumeratingWhitelist.getName(receiver) + SandboxInterceptor.printArgumentTypes(args));
        }
        if (StaticWhitelist.isPermanentlyBlacklistedConstructor(c)) {
            throw StaticWhitelist.rejectNew(c);
        }
        if (this.whitelist.permitsConstructor(c, args)) {
            if (c.getParameterCount() == 0 && args.length == 1 && args[0] instanceof Map) {
                Object newInstance = super.onNewInstance(invoker, receiver, new Object[0]);
                if (newInstance == null) {
                    throw new UnsupportedOperationException("Groovy map constructors may only be invoked using the 'new' keyword in the sandbox (attempted to construct " + String.valueOf(receiver) + " via a Groovy cast)");
                }
                for (Map.Entry entry : ((Map)args[0]).entrySet()) {
                    Checker.checkedSetProperty((Object)newInstance, entry.getKey(), (boolean)false, (boolean)false, (int)100, entry.getValue());
                }
                return newInstance;
            }
            return super.onNewInstance(invoker, receiver, args);
        }
        throw StaticWhitelist.rejectNew(c);
    }

    public Object onStaticCall(GroovyInterceptor.Invoker invoker, Class receiver, String method, Object ... args) throws Throwable {
        Method m = GroovyCallSiteSelector.staticMethod(receiver, method, args);
        if (m == null) {
            throw new RejectedAccessException("No such static method found: staticMethod " + EnumeratingWhitelist.getName(receiver) + " " + method + SandboxInterceptor.printArgumentTypes(args));
        }
        if (StaticWhitelist.isPermanentlyBlacklistedStaticMethod(m)) {
            throw StaticWhitelist.rejectStaticMethod(m);
        }
        if (this.whitelist.permitsStaticMethod(m, args)) {
            return super.onStaticCall(invoker, receiver, method, args);
        }
        throw StaticWhitelist.rejectStaticMethod(m);
    }

    public Object onSetProperty(GroovyInterceptor.Invoker invoker, Object receiver, String property, Object value) throws Throwable {
        Field field;
        Object[] propertyValueArgs;
        Method setPropertyMethod;
        Method setterMethod;
        if (receiver instanceof Script && !property.equals("binding") && !property.equals("metaClass")) {
            return super.onSetProperty(invoker, receiver, property, value);
        }
        Rejector rejector = null;
        Object[] valueArg = new Object[]{value};
        String setter = "set" + MetaClassHelper.capitalize((String)property);
        List<Method> setterMethods = GroovyCallSiteSelector.methods(receiver, setter, m -> m.getParameterCount() == 1);
        Method method = setterMethod = setterMethods.size() == 1 ? setterMethods.get(0) : GroovyCallSiteSelector.method(receiver, setter, valueArg);
        if (setterMethod != null) {
            if (SandboxInterceptor.permitsMethod(this.whitelist, setterMethod, receiver, valueArg)) {
                SandboxInterceptor.preCheckArgumentCasts(setterMethod, valueArg);
                return super.onSetProperty(invoker, receiver, property, value);
            }
            if (rejector == null) {
                rejector = () -> SandboxInterceptor.rejectMethod(setterMethod);
            }
        }
        if ((setPropertyMethod = GroovyCallSiteSelector.method(receiver, "setProperty", propertyValueArgs = new Object[]{property, value})) != null && !SandboxInterceptor.isSyntheticMethod(receiver, setPropertyMethod)) {
            if (this.whitelist.permitsMethod(setPropertyMethod, receiver, propertyValueArgs)) {
                SandboxInterceptor.preCheckArgumentCasts(setPropertyMethod, propertyValueArgs);
                return super.onSetProperty(invoker, receiver, property, value);
            }
            if (rejector == null) {
                rejector = () -> StaticWhitelist.rejectMethod(setPropertyMethod, receiver.getClass().getName() + "." + property);
            }
        }
        if ((field = GroovyCallSiteSelector.field(receiver, property)) != null) {
            if (SandboxInterceptor.permitsFieldSet(this.whitelist, field, receiver, value)) {
                Checker.preCheckedCast(field.getType(), (Object)value, (boolean)false, (boolean)false, (boolean)false);
                return super.onSetProperty(invoker, receiver, property, value);
            }
            if (rejector == null) {
                rejector = () -> SandboxInterceptor.rejectField(field);
            }
        }
        if (receiver instanceof Class) {
            Field staticField;
            Method staticSetterMethod;
            List<Method> staticSetterMethods = GroovyCallSiteSelector.staticMethods((Class)receiver, setter, m -> m.getParameterCount() == 1);
            Method method2 = staticSetterMethod = staticSetterMethods.size() == 1 ? staticSetterMethods.get(0) : GroovyCallSiteSelector.staticMethod((Class)receiver, setter, valueArg);
            if (staticSetterMethod != null) {
                if (this.whitelist.permitsStaticMethod(staticSetterMethod, valueArg)) {
                    SandboxInterceptor.preCheckArgumentCasts(staticSetterMethod, valueArg);
                    return super.onSetProperty(invoker, receiver, property, value);
                }
                if (rejector == null) {
                    rejector = () -> StaticWhitelist.rejectStaticMethod(staticSetterMethod);
                }
            }
            if ((staticField = GroovyCallSiteSelector.staticField((Class)receiver, property)) != null) {
                if (this.whitelist.permitsStaticFieldSet(staticField, value)) {
                    Checker.preCheckedCast(staticField.getType(), (Object)value, (boolean)false, (boolean)false, (boolean)false);
                    return super.onSetProperty(invoker, receiver, property, value);
                }
                if (rejector == null) {
                    rejector = () -> StaticWhitelist.rejectStaticField(staticField);
                }
            }
        }
        throw rejector != null ? rejector.reject() : SandboxInterceptor.unclassifiedField(receiver, property);
    }

    public Object onGetProperty(GroovyInterceptor.Invoker invoker, Object receiver, String property) throws Throwable {
        MetaMethod metaMethod;
        Object[] propertyArg;
        Method getPropertyMethod;
        String booleanGetter;
        Method booleanGetterMethod;
        MissingPropertyException mpe = null;
        if (receiver instanceof Script) {
            try {
                ((Script)receiver).getBinding().getVariable(property);
                return super.onGetProperty(invoker, receiver, property);
            }
            catch (MissingPropertyException x) {
                mpe = x;
            }
        }
        if (property.equals("length") && receiver.getClass().isArray()) {
            return super.onGetProperty(invoker, receiver, property);
        }
        Rejector rejector = null;
        Object[] noArgs = new Object[]{};
        String getter = "get" + MetaClassHelper.capitalize((String)property);
        Method getterMethod = GroovyCallSiteSelector.method(receiver, getter, noArgs);
        if (getterMethod != null) {
            if (SandboxInterceptor.permitsMethod(this.whitelist, getterMethod, receiver, noArgs)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector == null) {
                rejector = () -> SandboxInterceptor.rejectMethod(getterMethod);
            }
        }
        if ((booleanGetterMethod = GroovyCallSiteSelector.method(receiver, booleanGetter = "is" + MetaClassHelper.capitalize((String)property), noArgs)) != null && booleanGetterMethod.getReturnType() == Boolean.TYPE) {
            if (SandboxInterceptor.permitsMethod(this.whitelist, booleanGetterMethod, receiver, noArgs)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector == null) {
                rejector = () -> SandboxInterceptor.rejectMethod(booleanGetterMethod);
            }
        }
        Object[] selfArgs = new Object[]{receiver};
        for (Class<?> dgmClass : DGM_CLASSES) {
            Method dgmBooleanGetterMethod;
            Method dgmGetterMethod = GroovyCallSiteSelector.staticMethod(dgmClass, getter, selfArgs);
            if (dgmGetterMethod != null) {
                if (this.whitelist.permitsStaticMethod(dgmGetterMethod, selfArgs)) {
                    return super.onGetProperty(invoker, receiver, property);
                }
                if (rejector == null) {
                    rejector = () -> StaticWhitelist.rejectStaticMethod(dgmGetterMethod);
                }
            }
            if ((dgmBooleanGetterMethod = GroovyCallSiteSelector.staticMethod(dgmClass, booleanGetter, selfArgs)) == null || dgmBooleanGetterMethod.getReturnType() != Boolean.TYPE) continue;
            if (this.whitelist.permitsStaticMethod(dgmBooleanGetterMethod, selfArgs)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector != null) continue;
            rejector = () -> StaticWhitelist.rejectStaticMethod(dgmBooleanGetterMethod);
        }
        Field field = GroovyCallSiteSelector.field(receiver, property);
        if (field != null) {
            if (SandboxInterceptor.permitsFieldGet(this.whitelist, field, receiver)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector == null) {
                rejector = () -> SandboxInterceptor.rejectField(field);
            }
        }
        if ((getPropertyMethod = GroovyCallSiteSelector.method(receiver, "getProperty", propertyArg = new Object[]{property})) != null && !SandboxInterceptor.isSyntheticMethod(receiver, getPropertyMethod)) {
            if (this.whitelist.permitsMethod(getPropertyMethod, receiver, propertyArg)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector == null) {
                rejector = () -> StaticWhitelist.rejectMethod(getPropertyMethod, receiver.getClass().getName() + "." + property);
            }
        }
        if ((metaMethod = SandboxInterceptor.findMetaMethod(receiver, getter, noArgs)) instanceof ClosureMetaMethod) {
            return super.onGetProperty(invoker, receiver, property);
        }
        if (receiver instanceof Class) {
            Field staticField;
            Method staticBooleanGetterMethod;
            Method staticGetterMethod = GroovyCallSiteSelector.staticMethod((Class)receiver, getter, noArgs);
            if (staticGetterMethod != null) {
                if (this.whitelist.permitsStaticMethod(staticGetterMethod, noArgs)) {
                    return super.onGetProperty(invoker, receiver, property);
                }
                if (rejector == null) {
                    rejector = () -> StaticWhitelist.rejectStaticMethod(staticGetterMethod);
                }
            }
            if ((staticBooleanGetterMethod = GroovyCallSiteSelector.staticMethod((Class)receiver, booleanGetter, noArgs)) != null && staticBooleanGetterMethod.getReturnType() == Boolean.TYPE) {
                if (this.whitelist.permitsStaticMethod(staticBooleanGetterMethod, noArgs)) {
                    return super.onGetProperty(invoker, receiver, property);
                }
                if (rejector == null) {
                    rejector = () -> StaticWhitelist.rejectStaticMethod(staticBooleanGetterMethod);
                }
            }
            if ((staticField = GroovyCallSiteSelector.staticField((Class)receiver, property)) != null) {
                if (this.whitelist.permitsStaticFieldGet(staticField)) {
                    return super.onGetProperty(invoker, receiver, property);
                }
                if (rejector == null) {
                    rejector = () -> StaticWhitelist.rejectStaticField(staticField);
                }
            }
        }
        if (mpe != null) {
            throw mpe;
        }
        throw rejector != null ? rejector.reject() : SandboxInterceptor.unclassifiedField(receiver, property);
    }

    public Object onSuperCall(GroovyInterceptor.Invoker invoker, Class senderType, Object receiver, String method, Object ... args) throws Throwable {
        Method m = GroovyCallSiteSelector.method(receiver, method, args);
        if (m == null) {
            throw new RejectedAccessException("No such method found: super.method " + EnumeratingWhitelist.getName(receiver.getClass()) + " " + method + SandboxInterceptor.printArgumentTypes(args));
        }
        if (this.whitelist.permitsMethod(m, receiver, args)) {
            return super.onSuperCall(invoker, senderType, receiver, method, args);
        }
        throw StaticWhitelist.rejectMethod(m);
    }

    private static MissingPropertyException unclassifiedField(Object receiver, String property) {
        return new MissingPropertyException("No such field found: field " + EnumeratingWhitelist.getName(receiver.getClass()) + " " + property);
    }

    public Object onGetAttribute(GroovyInterceptor.Invoker invoker, Object receiver, String attribute) throws Throwable {
        Field staticField;
        Rejector rejector = null;
        Field field = GroovyCallSiteSelector.field(receiver, attribute);
        if (field != null) {
            if (SandboxInterceptor.permitsFieldGet(this.whitelist, field, receiver)) {
                return super.onGetAttribute(invoker, receiver, attribute);
            }
            rejector = () -> SandboxInterceptor.rejectField(field);
        }
        if (receiver instanceof Class && (staticField = GroovyCallSiteSelector.staticField((Class)receiver, attribute)) != null) {
            if (this.whitelist.permitsStaticFieldGet(staticField)) {
                return super.onGetAttribute(invoker, receiver, attribute);
            }
            rejector = () -> StaticWhitelist.rejectStaticField(staticField);
        }
        throw rejector != null ? rejector.reject() : SandboxInterceptor.unclassifiedField(receiver, attribute);
    }

    public Object onSetAttribute(GroovyInterceptor.Invoker invoker, Object receiver, String attribute, Object value) throws Throwable {
        Field staticField;
        Rejector rejector = null;
        Field field = GroovyCallSiteSelector.field(receiver, attribute);
        if (field != null) {
            if (SandboxInterceptor.permitsFieldSet(this.whitelist, field, receiver, value)) {
                Checker.preCheckedCast(field.getType(), (Object)value, (boolean)false, (boolean)false, (boolean)false);
                return super.onSetAttribute(invoker, receiver, attribute, value);
            }
            rejector = () -> SandboxInterceptor.rejectField(field);
        }
        if (receiver instanceof Class && (staticField = GroovyCallSiteSelector.staticField((Class)receiver, attribute)) != null) {
            if (this.whitelist.permitsStaticFieldSet(staticField, value)) {
                Checker.preCheckedCast(staticField.getType(), (Object)value, (boolean)false, (boolean)false, (boolean)false);
                return super.onSetAttribute(invoker, receiver, attribute, value);
            }
            rejector = () -> StaticWhitelist.rejectStaticField(staticField);
        }
        throw rejector != null ? rejector.reject() : SandboxInterceptor.unclassifiedField(receiver, attribute);
    }

    public Object onGetArray(GroovyInterceptor.Invoker invoker, Object receiver, Object index) throws Throwable {
        if (receiver.getClass().isArray() && index instanceof Integer) {
            return super.onGetArray(invoker, receiver, index);
        }
        Object[] args = new Object[]{index};
        Method method = GroovyCallSiteSelector.method(receiver, "getAt", args);
        if (method != null) {
            if (SandboxInterceptor.permitsMethod(this.whitelist, method, receiver, args)) {
                return super.onGetArray(invoker, receiver, index);
            }
            throw SandboxInterceptor.rejectMethod(method);
        }
        args = new Object[]{receiver, index};
        for (Class<?> dgm : DGM_CLASSES) {
            method = GroovyCallSiteSelector.staticMethod(dgm, "getAt", args);
            if (method == null) continue;
            if (this.whitelist.permitsStaticMethod(method, args)) {
                return super.onGetArray(invoker, receiver, index);
            }
            throw StaticWhitelist.rejectStaticMethod(method);
        }
        throw new RejectedAccessException("No such getAt method found: method " + EnumeratingWhitelist.getName(receiver) + "[" + EnumeratingWhitelist.getName(index) + "]");
    }

    public Object onSetArray(GroovyInterceptor.Invoker invoker, Object receiver, Object index, Object value) throws Throwable {
        if (receiver.getClass().isArray() && index instanceof Integer) {
            return super.onSetArray(invoker, receiver, index, value);
        }
        Object[] args = new Object[]{index, value};
        Method method = GroovyCallSiteSelector.method(receiver, "putAt", args);
        if (method != null) {
            if (SandboxInterceptor.permitsMethod(this.whitelist, method, receiver, args)) {
                return super.onSetArray(invoker, receiver, index, value);
            }
            throw SandboxInterceptor.rejectMethod(method);
        }
        args = new Object[]{receiver, index, value};
        for (Class<?> dgm : DGM_CLASSES) {
            method = GroovyCallSiteSelector.staticMethod(dgm, "putAt", args);
            if (method == null) continue;
            if (this.whitelist.permitsStaticMethod(method, args)) {
                return super.onSetArray(invoker, receiver, index, value);
            }
            throw StaticWhitelist.rejectStaticMethod(method);
        }
        throw new RejectedAccessException("No such putAt method found: putAt method " + EnumeratingWhitelist.getName(receiver) + "[" + EnumeratingWhitelist.getName(index) + "]=" + EnumeratingWhitelist.getName(value));
    }

    private static void preCheckArgumentCasts(Method method, Object[] args) throws Throwable {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (i == parameters.length - 1 && parameter.isVarArgs()) {
                Class<?> componentType = parameter.getType().getComponentType();
                for (int j = i; j < args.length; ++j) {
                    Object arg = args[j];
                    Checker.preCheckedCast(componentType, (Object)arg, (boolean)false, (boolean)false, (boolean)false);
                }
                continue;
            }
            Object arg = args[i];
            Checker.preCheckedCast(parameter.getType(), (Object)arg, (boolean)false, (boolean)false, (boolean)false);
        }
    }

    private static boolean isSyntheticMethod(Object receiver, Method method) {
        try {
            return receiver.getClass().getDeclaredMethod(method.getName(), String.class, Object.class).isSynthetic();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private static String printArgumentTypes(Object[] args) {
        StringBuilder b = new StringBuilder();
        for (Object arg : args) {
            b.append(' ');
            b.append(EnumeratingWhitelist.getName(arg));
        }
        return b.toString();
    }

    @CheckForNull
    private static MetaMethod findMetaMethod(@NonNull Object receiver, @NonNull String method, @NonNull Object[] args) {
        Object[] types = new Class[args.length];
        for (int i = 0; i < types.length; ++i) {
            Object arg = args[i];
            types[i] = arg == null ? Void.TYPE : arg.getClass();
        }
        try {
            return DefaultGroovyMethods.getMetaClass((Object)receiver).pickMethod(method, (Class[])types);
        }
        catch (GroovyRuntimeException x) {
            LOGGER.log(Level.FINE, "could not find metamethod for " + String.valueOf(receiver.getClass()) + "." + method + Arrays.toString(types), x);
            return null;
        }
    }

    private static boolean permitsFieldGet(@NonNull Whitelist whitelist, @NonNull Field field, @NonNull Object receiver) {
        if (Modifier.isStatic(field.getModifiers())) {
            return whitelist.permitsStaticFieldGet(field);
        }
        return whitelist.permitsFieldGet(field, receiver);
    }

    private static boolean permitsFieldSet(@NonNull Whitelist whitelist, @NonNull Field field, @NonNull Object receiver, @CheckForNull Object value) {
        if (Modifier.isStatic(field.getModifiers())) {
            return whitelist.permitsStaticFieldSet(field, value);
        }
        return whitelist.permitsFieldSet(field, receiver, value);
    }

    private static boolean permitsMethod(@NonNull Whitelist whitelist, @NonNull Method method, @NonNull Object receiver, @NonNull Object[] args) {
        if (Modifier.isStatic(method.getModifiers())) {
            return whitelist.permitsStaticMethod(method, args);
        }
        return whitelist.permitsMethod(method, receiver, args);
    }

    public static RejectedAccessException rejectMethod(@NonNull Method m) {
        if (Modifier.isStatic(m.getModifiers())) {
            return StaticWhitelist.rejectStaticMethod(m);
        }
        return StaticWhitelist.rejectMethod(m);
    }

    public static RejectedAccessException rejectField(@NonNull Field f) {
        if (Modifier.isStatic(f.getModifiers())) {
            return StaticWhitelist.rejectStaticField(f);
        }
        return StaticWhitelist.rejectField(f);
    }

    private static interface Rejector {
        @NonNull
        public RejectedAccessException reject();
    }
}

