/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves;

import com.trilead.ssh2.Connection;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.JavaProvider;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.slaves.SlaveComputer;
import hudson.util.VersionNumber;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Deprecated
public class JavaVersionChecker {
    private static final Logger LOGGER = Logger.getLogger(JavaVersionChecker.class.getName());
    private final SlaveComputer computer;
    private final TaskListener listener;
    private final String jvmOptions;
    private final Connection connection;

    public JavaVersionChecker(SlaveComputer computer, TaskListener listener, String jvmOptions, Connection connection) {
        this.computer = computer;
        this.listener = listener;
        this.jvmOptions = jvmOptions;
        this.connection = connection;
    }

    protected String resolveJava() throws InterruptedException, IOException {
        for (JavaProvider provider : JavaProvider.all()) {
            for (String javaCommand : provider.getJavas(this.computer, this.listener, this.connection)) {
                LOGGER.fine("Trying Java at " + javaCommand);
                try {
                    return this.checkJavaVersion(this.listener, javaCommand);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Failed to check the Java version", e);
                }
            }
        }
        throw new IOException("Java not found on " + this.computer + ". Install Java 8 or Java 11 on the Agent.");
    }

    @NonNull
    private String checkJavaVersion(TaskListener listener, String javaCommand) throws IOException, InterruptedException {
        listener.getLogger().println(Messages.SSHLauncher_CheckingDefaultJava(SSHLauncher.getTimestamp(), javaCommand));
        StringWriter output = new StringWriter();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.connection.exec(javaCommand + " " + this.jvmOptions + " -version", (OutputStream)out);
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(out.toByteArray()), Charset.defaultCharset()));
        String result = this.checkJavaVersion(listener.getLogger(), javaCommand, r, output);
        if (null == result) {
            listener.getLogger().println(Messages.SSHLauncher_UnknownJavaVersion(javaCommand));
            listener.getLogger().println(output);
            throw new IOException(Messages.SSHLauncher_UnknownJavaVersion(javaCommand));
        }
        return result;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public String checkJavaVersion(PrintStream logger, String javaCommand, BufferedReader r, StringWriter output) throws IOException {
        String line;
        while (null != (line = r.readLine())) {
            output.write(line);
            output.write("\n");
            if (!(line = line.toLowerCase(Locale.ENGLISH)).startsWith("java version \"") && !line.startsWith("openjdk version \"")) continue;
            String versionStr = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
            logger.println(Messages.SSHLauncher_JavaVersionResult(SSHLauncher.getTimestamp(), javaCommand, versionStr));
            VersionNumber minJavaLevel = JavaProvider.getMinJavaLevel();
            try {
                Number version = NumberFormat.getNumberInstance(Locale.US).parse(versionStr);
                if (version.doubleValue() < Double.parseDouble("1." + minJavaLevel)) {
                    throw new IOException(Messages.SSHLauncher_NoJavaFound2(line, minJavaLevel.toString()));
                }
            }
            catch (ParseException e) {
                throw new IOException(Messages.SSHLauncher_NoJavaFound2(line, minJavaLevel));
            }
            return javaCommand;
        }
        return null;
    }
}

