/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.trilead.ssh2.Connection;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.slaves.ComputerConnector;
import hudson.slaves.ComputerConnectorDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collections;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.security.core.Authentication;

public class SSHConnector
extends ComputerConnector {
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public int port;
    private String credentialsId;
    private String jvmOptions;
    private String javaPath;
    private String prefixStartSlaveCmd;
    private String suffixStartSlaveCmd;
    private Integer launchTimeoutSeconds;
    private Integer maxNumRetries;
    private Integer retryWaitTime;
    private SshHostKeyVerificationStrategy sshHostKeyVerificationStrategy;
    private String workDir;
    private Boolean tcpNoDelay;

    @DataBoundConstructor
    public SSHConnector(int port, String credentialsId) {
        this.setPort(port);
        this.credentialsId = credentialsId;
    }

    public SSHConnector(int port, String credentialsId, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds, Integer maxNumRetries, Integer retryWaitTime, SshHostKeyVerificationStrategy sshHostKeyVerificationStrategy) {
        this.setJvmOptions(jvmOptions);
        this.setPort(port);
        this.credentialsId = credentialsId;
        this.setJavaPath(javaPath);
        this.setPrefixStartSlaveCmd(prefixStartSlaveCmd);
        this.setSuffixStartSlaveCmd(suffixStartSlaveCmd);
        this.sshHostKeyVerificationStrategy = sshHostKeyVerificationStrategy;
        this.setLaunchTimeoutSeconds(launchTimeoutSeconds);
        this.setMaxNumRetries(maxNumRetries);
        this.setRetryWaitTime(retryWaitTime);
    }

    public SSHLauncher launch(@NonNull String host, TaskListener listener) {
        SSHLauncher sshLauncher = new SSHLauncher(host, this.port, this.credentialsId, this.jvmOptions, this.javaPath, this.prefixStartSlaveCmd, this.suffixStartSlaveCmd, this.launchTimeoutSeconds, this.maxNumRetries, this.retryWaitTime, this.sshHostKeyVerificationStrategy);
        sshLauncher.setWorkDir(this.workDir);
        sshLauncher.setTcpNoDelay(this.getTcpNoDelay());
        return sshLauncher;
    }

    @DataBoundSetter
    public void setJvmOptions(String value) {
        this.jvmOptions = Util.fixEmpty((String)value);
    }

    @DataBoundSetter
    public void setJavaPath(String value) {
        this.javaPath = Util.fixEmpty((String)value);
    }

    @DataBoundSetter
    public void setPrefixStartSlaveCmd(String value) {
        this.prefixStartSlaveCmd = Util.fixEmpty((String)value);
    }

    @DataBoundSetter
    public void setSuffixStartSlaveCmd(String value) {
        this.suffixStartSlaveCmd = Util.fixEmpty((String)value);
    }

    @DataBoundSetter
    public void setMaxNumRetries(Integer value) {
        this.maxNumRetries = value != null && value >= 0 ? value : SSHLauncher.DEFAULT_MAX_NUM_RETRIES;
    }

    @DataBoundSetter
    public void setLaunchTimeoutSeconds(Integer value) {
        this.launchTimeoutSeconds = value == null || value <= 0 ? SSHLauncher.DEFAULT_LAUNCH_TIMEOUT_SECONDS : value;
    }

    @DataBoundSetter
    public void setRetryWaitTime(Integer value) {
        this.retryWaitTime = value != null && value >= 0 ? value : SSHLauncher.DEFAULT_RETRY_WAIT_TIME;
    }

    @DataBoundSetter
    public void setSshHostKeyVerificationStrategy(SshHostKeyVerificationStrategy value) {
        this.sshHostKeyVerificationStrategy = value;
    }

    public void setPort(int value) {
        this.port = value == 0 ? 22 : value;
    }

    @DataBoundSetter
    public void setTcpNoDelay(Boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public SshHostKeyVerificationStrategy getSshHostKeyVerificationStrategy() {
        return this.sshHostKeyVerificationStrategy;
    }

    @DataBoundSetter
    public void setWorkDir(String workDir) {
        this.workDir = Util.fixEmptyAndTrim((String)workDir);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public int getPort() {
        return this.port;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    public String getPrefixStartSlaveCmd() {
        return this.prefixStartSlaveCmd;
    }

    public String getSuffixStartSlaveCmd() {
        return this.suffixStartSlaveCmd;
    }

    public Integer getLaunchTimeoutSeconds() {
        return this.launchTimeoutSeconds;
    }

    public Integer getMaxNumRetries() {
        return this.maxNumRetries;
    }

    public Integer getRetryWaitTime() {
        return this.retryWaitTime;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay != null ? this.tcpNoDelay : true;
    }

    @Extension
    public static class DescriptorImpl
    extends ComputerConnectorDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.SSHLauncher_DescriptorDisplayName();
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context, @QueryParameter String credentialsId) {
            Jenkins _context;
            Object object = _context = context instanceof AccessControlled ? (AccessControlled)context : Jenkins.get();
            if (_context == null || !_context.hasPermission(Computer.CONFIGURE)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardUsernameListBoxModel().includeMatchingAs(ACL.SYSTEM, context, StandardUsernameCredentials.class, Collections.singletonList(SSHLauncher.SSH_SCHEME), SSHAuthenticator.matcher(Connection.class)).includeCurrentValue(credentialsId);
        }

        @RequirePOST
        public FormValidation doCheckCredentialsId(@AncestorInPath ItemGroup context, @QueryParameter String value) {
            Jenkins _context;
            Object object = _context = context instanceof AccessControlled ? (AccessControlled)context : Jenkins.get();
            if (_context == null || !_context.hasPermission(Computer.CONFIGURE)) {
                return FormValidation.ok();
            }
            for (ListBoxModel.Option o : CredentialsProvider.listCredentialsInItemGroup(StandardUsernameCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM2, Collections.singletonList(SSHLauncher.SSH_SCHEME), (CredentialsMatcher)SSHAuthenticator.matcher(Connection.class))) {
                if (!StringUtils.equals((String)value, (String)o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.SSHLauncher_SelectedCredentialsMissing());
        }

        @RequirePOST
        public FormValidation doCheckLaunchTimeoutSeconds(String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            try {
                if (Integer.parseInt(value.trim()) < 0) {
                    return FormValidation.error((String)Messages.SSHConnector_LaunchTimeoutMustBePositive());
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.SSHConnector_LaunchTimeoutMustBeANumber());
            }
        }
    }
}

