/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.CertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.UsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.scm.SubversionSCM;
import hudson.scm.subversion.Messages;
import hudson.security.ACL;
import hudson.util.Scrambler;
import hudson.util.Secret;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.DestroyFailedException;
import jenkins.scm.impl.subversion.RemotableSVNErrorMessage;
import org.acegisecurity.Authentication;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;

public class CredentialsSVNAuthenticationProviderImpl
implements ISVNAuthenticationProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private final SVNAuthenticationBuilderProvider provider;
    private final SVNUnauthenticatedRealmObserver realmObserver = new RemotableSVNUnauthenticatedRealmObserver();
    private static final SVNAuthentication ANONYMOUS = new SVNUserNameAuthentication("", false, null, false);
    private static final Logger LOGGER = Logger.getLogger(CredentialsSVNAuthenticationProviderImpl.class.getName());
    private static final CredentialsMatcher MATCHER = CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)});

    public CredentialsSVNAuthenticationProviderImpl(Credentials credentials) {
        this(credentials, null, TaskListener.NULL);
    }

    public CredentialsSVNAuthenticationProviderImpl(Credentials credentials, Map<String, Credentials> credentialsByRealm, TaskListener listener) {
        this.provider = new RemotableSVNAuthenticationBuilderProvider(credentials, credentialsByRealm == null ? Collections.emptyMap() : credentialsByRealm, listener);
    }

    @Deprecated
    public CredentialsSVNAuthenticationProviderImpl(Credentials credentials, Map<String, Credentials> credentialsByRealm) {
        this(credentials, credentialsByRealm, TaskListener.NULL);
    }

    public static CredentialsSVNAuthenticationProviderImpl createAuthenticationProvider(Item context, String remote, String credentialsId, Map<String, String> additionalCredentialIds, TaskListener listener) {
        StandardCredentials defaultCredentials = credentialsId == null ? null : (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)remote).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsSVNAuthenticationProviderImpl.idMatcher(credentialsId), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)})}));
        HashMap<String, Credentials> additional = new HashMap<String, Credentials>();
        if (additionalCredentialIds != null) {
            for (Map.Entry<String, String> c : additionalCredentialIds.entrySet()) {
                StandardCredentials cred;
                if (c.getValue() == null || (cred = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsSVNAuthenticationProviderImpl.idMatcher(c.getValue()), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)})}))) == null) continue;
                additional.put(c.getKey(), (Credentials)cred);
            }
        }
        return new CredentialsSVNAuthenticationProviderImpl((Credentials)defaultCredentials, (Map<String, Credentials>)additional, listener);
    }

    @Deprecated
    public static CredentialsSVNAuthenticationProviderImpl createAuthenticationProvider(Item context, String remote, String credentialsId, Map<String, String> additionalCredentialIds) {
        return CredentialsSVNAuthenticationProviderImpl.createAuthenticationProvider(context, remote, credentialsId, additionalCredentialIds, TaskListener.NULL);
    }

    public static CredentialsSVNAuthenticationProviderImpl createAuthenticationProvider(Item context, SubversionSCM scm, SubversionSCM.ModuleLocation location, TaskListener listener) {
        StandardCredentials defaultCredentials = location == null ? null : (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)location.remote).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsSVNAuthenticationProviderImpl.idMatcher(location.credentialsId), MATCHER}));
        HashMap<String, Credentials> additional = new HashMap<String, Credentials>();
        if (scm != null) {
            for (SubversionSCM.AdditionalCredentials c : scm.getAdditionalCredentials()) {
                StandardCredentials cred;
                if (c.getCredentialsId() == null || (cred = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsSVNAuthenticationProviderImpl.idMatcher(c.getCredentialsId()), MATCHER}))) == null) continue;
                additional.put(c.getRealm(), (Credentials)cred);
            }
        }
        return new CredentialsSVNAuthenticationProviderImpl((Credentials)defaultCredentials, (Map<String, Credentials>)additional, listener);
    }

    @Deprecated
    public static CredentialsSVNAuthenticationProviderImpl createAuthenticationProvider(Item context, SubversionSCM scm, SubversionSCM.ModuleLocation location) {
        return CredentialsSVNAuthenticationProviderImpl.createAuthenticationProvider(context, scm, location, TaskListener.NULL);
    }

    private static CredentialsMatcher idMatcher(String credentialsId) {
        return credentialsId == null ? CredentialsMatchers.never() : CredentialsMatchers.withId((String)credentialsId);
    }

    public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
        int index;
        LOGGER.fine("Attempting auth for URL: " + url.toString() + "; Realm: " + realm);
        SVNAuthenticationBuilder builder = this.provider.getBuilder(realm);
        if (builder == null) {
            if (previousAuth == null && "svn.username".equals(kind)) {
                return ANONYMOUS;
            }
            this.realmObserver.observe(realm);
            return null;
        }
        List<SVNAuthentication> authentications = builder.build(kind, url);
        int n = index = previousAuth == null ? 0 : CredentialsSVNAuthenticationProviderImpl.indexOf(authentications, previousAuth) + 1;
        if (index >= authentications.size()) {
            if (previousAuth == null && "svn.username".equals(kind)) {
                return ANONYMOUS;
            }
            this.realmObserver.observe(realm);
            return null;
        }
        return authentications.get(index);
    }

    public void resetUnauthenticatedRealms() {
        this.realmObserver.reset();
    }

    public Set<String> getUnauthenticatedRealms() {
        return this.realmObserver.get();
    }

    private static int indexOf(List<SVNAuthentication> list, SVNAuthentication o) {
        int index = 0;
        for (SVNAuthentication v : list) {
            if (CredentialsSVNAuthenticationProviderImpl.equals(v, o)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static boolean equals(SVNAuthentication a1, SVNAuthentication a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.getClass() != a2.getClass()) {
            return false;
        }
        try {
            return CredentialsSVNAuthenticationProviderImpl.describeBean(a1).equals(CredentialsSVNAuthenticationProviderImpl.describeBean(a2));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    private static Map describeBean(Object o) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Map m = PropertyUtils.describe((Object)o);
        for (Map.Entry entry : m.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof char[])) continue;
            char[] chars = (char[])v;
            entry.setValue(new String(chars));
        }
        return m;
    }

    public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
        return 1;
    }

    public static class RemotableSVNUnauthenticatedRealmObserver
    implements SVNUnauthenticatedRealmObserver {
        private final Set<String> realms = new LinkedHashSet<String>();

        private Object writeReplace() {
            return Channel.current().export(SVNUnauthenticatedRealmObserver.class, (Object)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void observe(String realm) {
            Set<String> set = this.realms;
            synchronized (set) {
                this.realms.add(realm);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            Set<String> set = this.realms;
            synchronized (set) {
                this.realms.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<String> get() {
            Set<String> set = this.realms;
            synchronized (set) {
                return new LinkedHashSet<String>(this.realms);
            }
        }
    }

    public static interface SVNUnauthenticatedRealmObserver
    extends Serializable {
        public void observe(String var1);

        public void reset();

        public Set<String> get();
    }

    public static class RemotableSVNAuthenticationBuilderProvider
    implements SVNAuthenticationBuilderProvider {
        private static final long serialVersionUID = 1L;
        private final Credentials defaultCredentials;
        private final Map<String, Credentials> credentialsByRealm;
        @CheckForNull
        private final TaskListener listener;

        public RemotableSVNAuthenticationBuilderProvider(Credentials defaultCredentials, Map<String, Credentials> credentialsByRealm, TaskListener listener) {
            this.defaultCredentials = defaultCredentials;
            this.credentialsByRealm = credentialsByRealm;
            this.listener = listener == TaskListener.NULL ? null : listener;
        }

        @Deprecated
        public RemotableSVNAuthenticationBuilderProvider(Credentials defaultCredentials, Map<String, Credentials> credentialsByRealm) {
            this(defaultCredentials, credentialsByRealm, TaskListener.NULL);
        }

        private Object writeReplace() {
            return Channel.current().export(SVNAuthenticationBuilderProvider.class, (Object)this);
        }

        @Override
        public SVNAuthenticationBuilder getBuilder(String realm) {
            TaskListener l = this.listener == null ? TaskListener.NULL : this.listener;
            Credentials c = this.credentialsByRealm.get(realm);
            if (c != null) {
                l.getLogger().println(Messages.CredentialsSVNAuthenticationProviderImpl_credentials_in_realm(CredentialsNameProvider.name((Credentials)c), realm));
            } else {
                String name;
                c = this.defaultCredentials;
                String string = name = c != null ? CredentialsNameProvider.name((Credentials)c) : "<none>";
                if (this.credentialsByRealm.isEmpty()) {
                    l.getLogger().println(Messages.CredentialsSVNAuthenticationProviderImpl_sole_credentials(name, realm));
                } else {
                    l.getLogger().println(Messages.CredentialsSVNAuthenticationProviderImpl_missing_credentials(realm, StringUtils.join(this.credentialsByRealm.keySet(), (String)"\u2019, \u2018"), name));
                }
            }
            if (c instanceof CertificateCredentials) {
                return new SVNCertificateAuthenticationBuilder((CertificateCredentials)c);
            }
            if (c instanceof SSHUserPrivateKey) {
                return new SVNUsernamePrivateKeysAuthenticationBuilder((SSHUserPrivateKey)c);
            }
            if (c instanceof UsernamePasswordCredentials) {
                return new SVNUsernamePasswordAuthenticationBuilder((UsernamePasswordCredentials)c);
            }
            if (c instanceof UsernameCredentials) {
                return new SVNUsernameAuthenticationBuilder((UsernameCredentials)c);
            }
            return new SVNEmptyAuthenticationBuilder();
        }
    }

    public static interface SVNAuthenticationBuilderProvider
    extends Serializable {
        public SVNAuthenticationBuilder getBuilder(String var1);
    }

    public static interface SVNAuthenticationBuilder
    extends Serializable {
        public List<SVNAuthentication> build(String var1, SVNURL var2);
    }

    public static class SVNCertificateAuthenticationBuilder
    implements SVNAuthenticationBuilder {
        private static final long serialVersionUID = 1L;
        private final byte[] certificateFile;
        private final String password;

        public SVNCertificateAuthenticationBuilder(CertificateCredentials c) {
            String password = c.getPassword().getPlainText();
            this.password = Scrambler.scramble((String)password);
            char[] passwordChars = password.toCharArray();
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(passwordChars);
            try {
                KeyStore dst = KeyStore.getInstance("PKCS12");
                dst.load(null, null);
                KeyStore src = c.getKeyStore();
                Enumeration<String> e = src.aliases();
                while (e.hasMoreElements()) {
                    KeyStore.Entry entry;
                    String alias = e.nextElement();
                    try {
                        entry = src.getEntry(alias, null);
                    }
                    catch (UnrecoverableEntryException e1) {
                        try {
                            entry = src.getEntry(alias, passwordProtection);
                        }
                        catch (UnrecoverableEntryException e2) {
                            throw new RuntimeException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)"Unable to save certificate").getFullMessage(), e2);
                        }
                    }
                    dst.setEntry(alias, entry, passwordProtection);
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                dst.store(bos, passwordChars);
                this.certificateFile = bos.toByteArray();
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException(new RemotableSVNErrorMessage(SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, "Unable to save certificate").getFullMessage(), e);
            }
            finally {
                try {
                    passwordProtection.destroy();
                }
                catch (DestroyFailedException destroyFailedException) {}
                Arrays.fill(passwordChars, ' ');
            }
        }

        @Override
        public List<SVNAuthentication> build(String kind, SVNURL url) {
            if ("svn.ssl.client-passphrase".equals(kind)) {
                SVNSSLAuthentication authentication = SVNSSLAuthentication.newInstance((byte[])this.certificateFile, (char[])Scrambler.descramble((String)this.password).toCharArray(), (boolean)false, (SVNURL)url, (boolean)false);
                return Collections.singletonList(authentication);
            }
            return Collections.emptyList();
        }
    }

    public static class SVNUsernamePrivateKeysAuthenticationBuilder
    implements SVNAuthenticationBuilder {
        private static final long serialVersionUID = 1L;
        private final String username;
        private final String passphrase;
        private final List<String> privateKeys;

        public SVNUsernamePrivateKeysAuthenticationBuilder(SSHUserPrivateKey c) {
            this.username = c.getUsername();
            Secret secret = c.getPassphrase();
            this.passphrase = secret != null ? Scrambler.scramble((String)secret.getPlainText()) : null;
            this.privateKeys = new ArrayList<String>(c.getPrivateKeys());
        }

        @Override
        public List<SVNAuthentication> build(String kind, SVNURL url) {
            ArrayList<SVNAuthentication> result = new ArrayList<SVNAuthentication>();
            if ("svn.ssh".equals(kind)) {
                for (String privateKey : this.privateKeys) {
                    result.add((SVNAuthentication)new SVNSSHAuthentication(this.username, privateKey.toCharArray(), Scrambler.descramble((String)this.passphrase), -1, false, url, false));
                }
            }
            return result;
        }
    }

    public static class SVNUsernamePasswordAuthenticationBuilder
    implements SVNAuthenticationBuilder {
        private static final long serialVersionUID = 1L;
        private final String username;
        private final String password;

        public SVNUsernamePasswordAuthenticationBuilder(UsernamePasswordCredentials c) {
            this.username = c.getUsername();
            this.password = Scrambler.scramble((String)c.getPassword().getPlainText());
        }

        @Override
        public List<SVNAuthentication> build(String kind, SVNURL url) {
            if ("svn.simple".equals(kind)) {
                return Collections.singletonList(new SVNPasswordAuthentication(this.username, Scrambler.descramble((String)this.password), false, url, false));
            }
            if ("svn.ssh".equals(kind)) {
                return Collections.singletonList(new SVNSSHAuthentication(this.username, Scrambler.descramble((String)this.password), -1, false, url, false));
            }
            return Collections.emptyList();
        }
    }

    public static class SVNUsernameAuthenticationBuilder
    implements SVNAuthenticationBuilder {
        private static final long serialVersionUID = 1L;
        private final String username;

        public SVNUsernameAuthenticationBuilder(UsernameCredentials c) {
            this.username = c.getUsername();
        }

        @Override
        public List<SVNAuthentication> build(String kind, SVNURL url) {
            if ("svn.username".equals(kind)) {
                return Collections.singletonList(new SVNUserNameAuthentication(this.username, true, url, true));
            }
            return Collections.emptyList();
        }
    }

    public static class SVNEmptyAuthenticationBuilder
    implements SVNAuthenticationBuilder {
        private static final long serialVersionUID = 1L;

        @Override
        public List<SVNAuthentication> build(String kind, SVNURL url) {
            return Collections.emptyList();
        }
    }
}

