/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.subversion;

import hudson.scm.SubversionEventHandlerImpl;
import hudson.scm.SubversionSCM;
import hudson.scm.subversion.Messages;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.scm.impl.subversion.RemotableSVNErrorMessage;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;

final class SubversionUpdateEventHandler
extends SubversionEventHandlerImpl
implements ISVNExternalsHandler {
    private final Map<File, SVNExternalDetails> externalDetails = new HashMap<File, SVNExternalDetails>();
    private final List<SubversionSCM.External> externals;
    private final String modulePath;
    private final boolean cancelProcessOnExternalsFailed;

    @Deprecated
    public SubversionUpdateEventHandler(PrintStream out, List<SubversionSCM.External> externals, File moduleDir, String modulePath) {
        this(out, externals, moduleDir, modulePath, false, false);
    }

    @Deprecated
    public SubversionUpdateEventHandler(PrintStream out, List<SubversionSCM.External> externals, File moduleDir, String modulePath, boolean quietOperation) {
        this(out, externals, moduleDir, modulePath, quietOperation, false);
    }

    public SubversionUpdateEventHandler(PrintStream out, List<SubversionSCM.External> externals, File moduleDir, String modulePath, boolean quietOperation, boolean cancelProcessOnExternalsFailed) {
        super(out, moduleDir, quietOperation);
        this.externals = externals;
        this.modulePath = modulePath;
        this.cancelProcessOnExternalsFailed = cancelProcessOnExternalsFailed;
    }

    public SVNRevision[] handleExternal(File externalPath, SVNURL externalURL, SVNRevision externalRevision, SVNRevision externalPegRevision, String externalsDefinition, SVNRevision externalsWorkingRevision) {
        long revisionNumber = -1L;
        if (SVNRevision.isValidRevisionNumber((long)externalRevision.getNumber())) {
            revisionNumber = externalRevision.getNumber();
        } else if (SVNRevision.isValidRevisionNumber((long)externalPegRevision.getNumber())) {
            revisionNumber = externalPegRevision.getNumber();
        }
        SVNExternalDetails details = new SVNExternalDetails(externalURL, revisionNumber);
        this.out.println("\n<-- Got one external: " + externalPath.getName() + ", svn url: " + String.valueOf(details.getUrl()) + " -->");
        this.externalDetails.put(externalPath, details);
        return new SVNRevision[]{externalRevision, externalPegRevision};
    }

    @Override
    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        SVNEventAction action = event.getAction();
        if (action == SVNEventAction.UPDATE_EXTERNAL || action == SVNEventAction.UPDATE_COMPLETED) {
            File file = event.getFile();
            SVNExternalDetails details = this.externalDetails.remove(file);
            if (details != null) {
                String path;
                try {
                    path = SubversionUpdateEventHandler.getLocalPath(this.getRelativePath(file));
                }
                catch (IOException e) {
                    throw new SVNException((SVNErrorMessage)new RemotableSVNErrorMessage(SVNErrorCode.FS_GENERAL, e));
                }
                this.out.println(Messages.SubversionUpdateEventHandler_FetchExternal(details.getUrl(), event.getRevision(), file));
                this.externals.add(new SubversionSCM.External(this.modulePath + "/" + path, details.getUrl(), details.getRevision()));
            }
        } else if (action == SVNEventAction.FAILED_EXTERNAL) {
            File file = event.getFile();
            SVNExternalDetails details = this.externalDetails.get(file);
            if (details != null) {
                this.out.println(Messages.SubversionUpdateEventHandler_FetchExternal(details.getUrl(), event.getRevision(), file) + " failed!");
            }
            if (this.cancelProcessOnExternalsFailed) {
                throw new SVNException((SVNErrorMessage)new RemotableSVNErrorMessage(SVNErrorCode.CL_ERROR_PROCESSING_EXTERNALS, SVNErrorCode.CL_ERROR_PROCESSING_EXTERNALS.getDescription() + ": <" + file.getName() + ">"));
            }
        }
        super.handleEvent(event, progress);
    }

    public void checkCancelled() throws SVNCancelException {
        if (Thread.interrupted()) {
            throw new SVNCancelException();
        }
    }

    private static class SVNExternalDetails {
        private final SVNURL url;
        private final long revision;

        private SVNExternalDetails(SVNURL url, long revision) {
            this.url = url;
            this.revision = revision;
        }

        public SVNURL getUrl() {
            return this.url;
        }

        public long getRevision() {
            return this.revision;
        }
    }
}

