/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.thoughtworks.xstream.XStream;
import hudson.XmlFile;
import hudson.model.AbstractProject;
import hudson.scm.SubversionSCM;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SvnExternalsFileManager {
    private static final String SVN_EXTERNALS_FILE = "svnexternals.txt";
    private static final XStream XSTREAM = new XStream2();
    private static Map<AbstractProject, Object> projectExternalsCache;

    SvnExternalsFileManager() {
    }

    @Nonnull
    private static synchronized Object getFileLockItem(AbstractProject project) {
        Object item;
        if (projectExternalsCache == null) {
            projectExternalsCache = new WeakHashMap<AbstractProject, Object>();
        }
        if ((item = projectExternalsCache.get(project)) == null) {
            item = new Object();
            projectExternalsCache.put(project, item);
        }
        return item;
    }

    @Nonnull
    private static File getExternalsFile(AbstractProject project) {
        return new File(project.getRootDir(), SVN_EXTERNALS_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static List<SubversionSCM.External> parseExternalsFile(AbstractProject project) throws IOException {
        Object lock;
        File file = SvnExternalsFileManager.getExternalsFile(project);
        Object object = lock = SvnExternalsFileManager.getFileLockItem(project);
        synchronized (object) {
            if (file.exists()) {
                try {
                    return (List)new XmlFile(XSTREAM, file).read();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeExternalsFile(AbstractProject project, List<SubversionSCM.External> externals) throws IOException {
        Object lock;
        Object object = lock = SvnExternalsFileManager.getFileLockItem(project);
        synchronized (object) {
            new XmlFile(XSTREAM, SvnExternalsFileManager.getExternalsFile(project)).write(externals);
        }
    }

    static {
        XSTREAM.alias("external", SubversionSCM.External.class);
    }
}

