/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;

public final class SVNWeb
extends SubversionRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    public final URL url;

    @DataBoundConstructor
    public SVNWeb(URL url) throws MalformedURLException {
        this.url = SVNWeb.normalizeToEndWithSlash((URL)url);
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        int r = path.getLogEntry().getRevision();
        return new URL(this.url, "diff/" + SVNWeb.trimHeadSlash((String)path.getValue()) + this.param().add("rev1=" + (r - 1) + ";rev2=" + r));
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        int r = path.getLogEntry().getRevision();
        return new URL(this.url, "view/" + SVNWeb.trimHeadSlash((String)path.getValue()) + this.param().add("rev=" + r));
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        int r = changeSet.getRevision();
        return new URL(this.url, "revision/" + this.param().add("rev=" + r));
    }

    private QueryBuilder param() {
        return new QueryBuilder(this.url.getQuery());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "SVN::Web";
        }
    }
}

