/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.subversion;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.scm.SubversionRepositoryStatus;
import hudson.scm.SubversionSCM;
import hudson.security.ACL;
import hudson.util.IOException2;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import jenkins.scm.impl.subversion.Messages;
import jenkins.scm.impl.subversion.SVNRepositoryView;
import net.jcip.annotations.GuardedBy;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubversionSCMSource
extends SCMSource {
    private static final String DEFAULT_INCLUDES = "trunk,branches/*,tags/*,sandbox/*";
    private static final String DEFAULT_EXCLUDES = "";
    public static final StringListComparator COMPARATOR = new StringListComparator();
    public static final Logger LOGGER = Logger.getLogger(SubversionSCMSource.class.getName());
    private final String remoteBase;
    private final String credentialsId;
    private final String includes;
    private final String excludes;
    @GuardedBy(value="this")
    private transient String uuid;

    @DataBoundConstructor
    public SubversionSCMSource(String id, String remoteBase, String credentialsId, String includes, String excludes) {
        super(id);
        this.remoteBase = StringUtils.removeEnd((String)remoteBase, (String)"/") + "/";
        this.credentialsId = credentialsId;
        this.includes = StringUtils.defaultIfEmpty((String)includes, (String)DEFAULT_INCLUDES);
        this.excludes = StringUtils.defaultIfEmpty((String)excludes, (String)DEFAULT_EXCLUDES);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getRemoteBase() {
        return this.remoteBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getUuid() {
        if (this.uuid == null) {
            SVNRepositoryView repository = null;
            try {
                SVNURL repoURL = SVNURL.parseURIEncoded((String)this.remoteBase);
                repository = this.openSession(repoURL);
                this.uuid = repository.getUuid();
            }
            catch (SVNException e) {
                try {
                    LOGGER.log(Level.WARNING, "Could not connect to remote repository " + this.remoteBase + " to determine UUID", e);
                }
                catch (Throwable throwable) {
                    SubversionSCMSource.closeSession(repository);
                    throw throwable;
                }
                SubversionSCMSource.closeSession(repository);
            }
            SubversionSCMSource.closeSession(repository);
        }
        return this.uuid;
    }

    @NonNull
    protected void retrieve(@NonNull SCMHeadObserver observer, @NonNull TaskListener listener) throws IOException {
        SVNRepositoryView repository = null;
        try {
            listener.getLogger().println("Opening conection to " + this.remoteBase);
            SVNURL repoURL = SVNURL.parseURIEncoded((String)this.remoteBase);
            repository = this.openSession(repoURL);
            String repoPath = SubversionSCM.DescriptorImpl.getRelativePath(repoURL, repository.getRepository());
            List<String> prefix = Collections.emptyList();
            this.fetch(listener, repository, -1L, repoPath, SubversionSCMSource.toPaths(SubversionSCMSource.splitCludes(this.includes)), prefix, prefix, SubversionSCMSource.toPaths(SubversionSCMSource.splitCludes(this.excludes)), this.getCriteria(), observer);
        }
        catch (SVNException e) {
            try {
                e.printStackTrace(listener.error("Could not communicate with Subversion server"));
                throw new IOException2(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SubversionSCMSource.closeSession(repository);
                throw throwable;
            }
        }
        SubversionSCMSource.closeSession(repository);
    }

    protected SCMRevision retrieve(@NonNull SCMHead head, @NonNull TaskListener listener) throws IOException {
        SCMRevisionImpl sCMRevisionImpl;
        SVNRepositoryView repository = null;
        try {
            listener.getLogger().println("Opening conection to " + this.remoteBase);
            SVNURL repoURL = SVNURL.parseURIEncoded((String)this.remoteBase);
            repository = this.openSession(repoURL);
            String repoPath = SubversionSCM.DescriptorImpl.getRelativePath(repoURL, repository.getRepository());
            String path = SVNPathUtil.append((String)repoPath, (String)head.getName());
            SVNRepositoryView.NodeEntry svnEntry = repository.getNode(path, -1L);
            sCMRevisionImpl = new SCMRevisionImpl(head, svnEntry.getRevision());
        }
        catch (SVNException e) {
            try {
                throw new IOException2(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SubversionSCMSource.closeSession(repository);
                throw throwable;
            }
        }
        SubversionSCMSource.closeSession(repository);
        return sCMRevisionImpl;
    }

    private static void closeSession(@CheckForNull SVNRepositoryView repository) {
        if (repository != null) {
            repository.close();
        }
    }

    private SVNRepositoryView openSession(SVNURL repoURL) throws SVNException {
        return new SVNRepositoryView(repoURL, this.credentialsId == null ? null : (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)this.getOwner(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)repoURL.toString()).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)this.credentialsId), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)})})));
    }

    void fetch(@NonNull TaskListener listener, final @NonNull SVNRepositoryView repository, long rev, @NonNull String repoPath, @NonNull SortedSet<List<String>> paths, @NonNull List<String> prefix, @NonNull List<String> realPath, @NonNull SortedSet<List<String>> excludedPaths, @CheckForNull SCMSourceCriteria branchCriteria, @NonNull SCMHeadObserver observer) throws IOException, SVNException {
        String svnPath = SVNPathUtil.append((String)repoPath, (String)StringUtils.join(realPath, (char)'/'));
        assert (prefix.size() == realPath.size());
        assert (SubversionSCMSource.wildcardStartsWith(realPath, prefix));
        SortedMap<List<String>, SortedSet<List<String>>> includePaths = SubversionSCMSource.groupPaths(paths, prefix);
        listener.getLogger().println("Checking directory " + svnPath + (rev > -1L ? "@" + rev : "@HEAD"));
        SVNRepositoryView.NodeEntry node = repository.getNode(svnPath, rev);
        if (!SVNNodeKind.DIR.equals(node.getType()) || node.getChildren() == null) {
            return;
        }
        for (Map.Entry<List<String>, SortedSet<List<String>>> entry : includePaths.entrySet()) {
            for (List list : entry.getValue()) {
                String name = (String)list.get(prefix.size());
                SVNRepositoryView.ChildEntry[] children = (SVNRepositoryView.ChildEntry[])node.getChildren().clone();
                Arrays.sort(children, new Comparator<SVNRepositoryView.ChildEntry>(){

                    @Override
                    public int compare(SVNRepositoryView.ChildEntry o1, SVNRepositoryView.ChildEntry o2) {
                        long diff = o2.getRevision() - o1.getRevision();
                        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
                    }
                });
                for (SVNRepositoryView.ChildEntry svnEntry : children) {
                    if (svnEntry.getType() != SVNNodeKind.DIR || !SubversionSCMSource.isMatch(svnEntry.getName(), name)) continue;
                    List<String> childPrefix = SubversionSCMSource.copyAndAppend(prefix, name);
                    List<String> childRealPath = SubversionSCMSource.copyAndAppend(realPath, svnEntry.getName());
                    if (SubversionSCMSource.wildcardStartsWith(childRealPath, excludedPaths)) continue;
                    if (list.equals(childPrefix)) {
                        final String childPath = StringUtils.join(childRealPath, (char)'/');
                        final String candidateRootPath = SVNPathUtil.append((String)repoPath, (String)childPath);
                        final long candidateRevision = svnEntry.getRevision();
                        final long lastModified = svnEntry.getLastModified();
                        listener.getLogger().println("Checking candidate branch " + candidateRootPath + "@" + candidateRevision);
                        if (branchCriteria == null || branchCriteria.isHead(new SCMSourceCriteria.Probe(){

                            public String name() {
                                return childPath;
                            }

                            public long lastModified() {
                                return lastModified;
                            }

                            public boolean exists(@NonNull String path) throws IOException {
                                try {
                                    return repository.checkPath(SVNPathUtil.append((String)candidateRootPath, (String)path), candidateRevision) != SVNNodeKind.NONE;
                                }
                                catch (SVNException e) {
                                    throw new IOException2(e.getMessage(), (Throwable)e);
                                }
                            }
                        }, listener)) {
                            listener.getLogger().println("Met criteria");
                            SCMHead head = new SCMHead(childPath);
                            observer.observe(head, (SCMRevision)new SCMRevisionImpl(head, svnEntry.getRevision()));
                            if (observer.isObserving()) continue;
                            return;
                        }
                        listener.getLogger().println("Does not meet criteria");
                        continue;
                    }
                    this.fetch(listener, repository, svnEntry.getRevision(), repoPath, paths, childPrefix, childRealPath, excludedPaths, branchCriteria, observer);
                }
            }
        }
    }

    @NonNull
    private static <T> List<T> copyAndAppend(@NonNull List<T> list, T ... values) {
        ArrayList<T> childPrefix = new ArrayList<T>(list.size() + values.length);
        childPrefix.addAll(list);
        childPrefix.addAll(Arrays.asList(values));
        return childPrefix;
    }

    @NonNull
    static SortedMap<List<String>, SortedSet<List<String>>> groupPaths(@NonNull SortedSet<List<String>> pathSegments, @NonNull List<String> prefix) {
        String optimization;
        pathSegments = SubversionSCMSource.filterPaths(pathSegments, prefix);
        TreeMap<List<String>, SortedSet<List<String>>> result = new TreeMap<List<String>, SortedSet<List<String>>>(COMPARATOR);
        while (!pathSegments.isEmpty()) {
            ArrayList<String> longestPrefix = null;
            int longestIndex = -1;
            for (ArrayList<String> arrayList : pathSegments) {
                if (longestPrefix == null) {
                    longestPrefix = arrayList;
                    longestIndex = SubversionSCMSource.indexOfNextWildcard(arrayList, prefix.size());
                    continue;
                }
                int index = SubversionSCMSource.indexOfNextWildcard((List<String>)arrayList, prefix.size());
                if (index <= longestIndex) continue;
                longestPrefix = arrayList;
                longestIndex = index;
            }
            assert (longestPrefix != null);
            longestPrefix = new ArrayList<String>(longestPrefix.subList(0, longestIndex));
            SortedSet<List<String>> group = SubversionSCMSource.filterPaths(pathSegments, longestPrefix);
            result.put(longestPrefix, group);
            pathSegments.removeAll(group);
        }
        while (null != (optimization = SubversionSCMSource.getOptimizationPoint(result.keySet(), prefix.size()))) {
            List<String> optimizedPrefix = SubversionSCMSource.copyAndAppend(prefix, optimization);
            TreeSet<List<String>> optimizedGroup = new TreeSet<List<String>>(COMPARATOR);
            Iterator iterator = result.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!SubversionSCMSource.startsWith((List)entry.getKey(), optimizedPrefix)) continue;
                iterator.remove();
                optimizedGroup.addAll((Collection)entry.getValue());
            }
            result.put(optimizedPrefix, optimizedGroup);
        }
        return result;
    }

    @CheckForNull
    static String getOptimizationPoint(@NonNull Set<List<String>> newPrefixes, int oldPrefixSize) {
        HashSet<String> set = new HashSet<String>();
        for (List<String> p : newPrefixes) {
            if (p.size() <= oldPrefixSize) continue;
            String value = p.get(oldPrefixSize);
            if (set.contains(value)) {
                return value;
            }
            set.add(value);
        }
        return null;
    }

    static int indexOfNextWildcard(@NonNull List<String> pathSegment, int startIndex) {
        String segment;
        int index = startIndex;
        ListIterator<String> i = pathSegment.listIterator(index);
        while (i.hasNext() && (segment = i.next()).indexOf(42) == -1 && segment.indexOf(63) == -1) {
            ++index;
        }
        return index;
    }

    static boolean startsWith(@NonNull List<String> value, @NonNull List<String> prefix) {
        if (value.size() < prefix.size()) {
            return false;
        }
        ListIterator<String> i1 = value.listIterator();
        ListIterator<String> i2 = prefix.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next().equals(i2.next())) continue;
            return false;
        }
        return true;
    }

    static boolean wildcardStartsWith(@NonNull List<String> value, @NonNull List<String> wildcardPrefix) {
        if (value.size() < wildcardPrefix.size()) {
            return false;
        }
        ListIterator<String> i1 = value.listIterator();
        ListIterator<String> i2 = wildcardPrefix.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (SubversionSCMSource.isMatch(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    static boolean wildcardStartsWith(@NonNull List<String> value, @NonNull Collection<List<String>> wildcardPrefixes) {
        for (List<String> wildcardPrefix : wildcardPrefixes) {
            if (!SubversionSCMSource.wildcardStartsWith(value, wildcardPrefix)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    static SortedSet<List<String>> filterPaths(@NonNull SortedSet<List<String>> pathSegments, @NonNull List<String> prefix) {
        TreeSet<List<String>> result = new TreeSet<List<String>>(COMPARATOR);
        for (List list : pathSegments) {
            if (!SubversionSCMSource.startsWith(list, prefix)) continue;
            result.add(list);
        }
        return result;
    }

    @NonNull
    static SortedSet<List<String>> toPaths(@NonNull SortedSet<String> pathStrings) {
        TreeSet<List<String>> result = new TreeSet<List<String>>(COMPARATOR);
        for (String clude : pathStrings) {
            result.add(Arrays.asList(clude.split("/")));
        }
        return result;
    }

    @NonNull
    static SortedSet<String> splitCludes(@CheckForNull String cludes) {
        TreeSet<String> result = new TreeSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(StringUtils.defaultString((String)cludes), ",");
        while (tokenizer.hasMoreTokens()) {
            String clude = tokenizer.nextToken().trim();
            if (!StringUtils.isNotEmpty((String)clude)) continue;
            result.add(clude.trim());
        }
        return result;
    }

    static boolean isMatch(@NonNull String value, @NonNull String wildcareMatcher) {
        return FilenameUtils.wildcardMatch((String)value, (String)wildcareMatcher, (IOCase)IOCase.SENSITIVE);
    }

    @NonNull
    public SubversionSCM build(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        if (revision != null && !head.equals((Object)revision.getHead())) {
            revision = null;
        }
        if (revision != null && !(revision instanceof SCMRevisionImpl)) {
            revision = null;
        }
        StringBuilder remote = new StringBuilder(this.remoteBase);
        if (!this.remoteBase.endsWith("/")) {
            remote.append('/');
        }
        remote.append(head.getName());
        if (revision != null) {
            remote.append('@').append(((SCMRevisionImpl)revision).getRevision());
        } else if (remote.indexOf("@") != -1) {
            remote.append('@');
        }
        return new SubversionSCM(remote.toString(), this.credentialsId, ".");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class ListenerImpl
    extends SubversionRepositoryStatus.Listener {
        public static final int RECENT_SIZE = 64;
        @GuardedBy(value="itself")
        private final Map<String, Long> recentUpdates = new LinkedHashMap<String, Long>(64){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Long> eldest) {
                return this.size() >= 64;
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onNotify(UUID uuid, long revision, Set<String> paths) {
            String id = uuid.toString();
            Map<String, Long> map = this.recentUpdates;
            synchronized (map) {
                Long recentUpdate = this.recentUpdates.get(id);
                if (recentUpdate != null && revision == recentUpdate) {
                    LOGGER.log(Level.FINE, "Received duplicate post-commit hook from {0} for revision {1} on paths {2}", new Object[]{uuid, revision, paths});
                    return false;
                }
                this.recentUpdates.put(id, revision);
            }
            LOGGER.log(Level.INFO, "Received post-commit hook from {0} for revision {1} on paths {2}", new Object[]{uuid, revision, paths});
            boolean notified = false;
            Authentication old = SecurityContextHolder.getContext().getAuthentication();
            SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
            try {
                for (SCMSourceOwner owner : SCMSourceOwners.all()) {
                    for (SCMSource source : owner.getSCMSources()) {
                        if (!(source instanceof SubversionSCMSource) || !id.equals(((SubversionSCMSource)source).getUuid())) continue;
                        LOGGER.log(Level.INFO, "SCM changes detected relevant to {0}. Notifying update", owner.getFullDisplayName());
                        owner.onSCMSourceUpdated(source);
                        notified = true;
                    }
                }
            }
            finally {
                SecurityContextHolder.getContext().setAuthentication(old);
            }
            if (!notified) {
                LOGGER.log(Level.INFO, "No subversion consumers for UUID {0}", uuid);
            }
            return notified;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        static final Pattern URL_PATTERN = Pattern.compile("(https?|svn(\\+[a-z0-9]+)?|file)://.+");

        public String getDisplayName() {
            return Messages.SubversionSCMSource_DisplayName();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String remoteBase) {
            List domainRequirements = URIRequirementBuilder.fromUri((String)remoteBase.trim()).build();
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(StandardCertificateCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, (List)domainRequirements));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringListComparator
    implements Comparator<List<String>> {
        StringListComparator() {
        }

        @Override
        public int compare(List<String> o1, List<String> o2) {
            ListIterator<String> e1 = o1.listIterator();
            ListIterator<String> e2 = o2.listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                String s2;
                String s1 = e1.next();
                int rv = s1.compareTo(s2 = e2.next());
                if (rv == 0) continue;
                return rv;
            }
            if (e1.hasNext()) {
                return -1;
            }
            if (e2.hasNext()) {
                return 1;
            }
            return 0;
        }
    }

    public static class SCMRevisionImpl
    extends SCMRevision {
        private long revision;

        public SCMRevisionImpl(SCMHead head, long revision) {
            super(head);
            this.revision = revision;
        }

        public long getRevision() {
            return this.revision;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            SCMRevisionImpl that = (SCMRevisionImpl)((Object)o);
            return this.revision == that.revision && this.getHead().equals((Object)that.getHead());
        }

        public int hashCode() {
            return (int)(this.revision ^ this.revision >>> 32);
        }
    }
}

