/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNEventAdapter;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SubversionEventHandlerImpl
extends SVNEventAdapter {
    protected final PrintStream out;
    protected final File baseDir;

    public SubversionEventHandlerImpl(PrintStream out, File baseDir) {
        this.out = out;
        this.baseDir = baseDir;
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        SVNStatusType contentsStatus;
        SVNEventAction action;
        File file = event.getFile();
        String path = null;
        if (file != null) {
            try {
                path = this.getRelativePath(file);
            }
            catch (IOException e) {
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (Throwable)e));
            }
            path = SubversionEventHandlerImpl.getLocalPath(path);
        }
        if ((action = event.getAction()) == SVNEventAction.COMMIT_ADDED) {
            this.out.println("Adding         " + path);
            return;
        }
        if (action == SVNEventAction.COMMIT_DELETED) {
            this.out.println("Deleting       " + path);
            return;
        }
        if (action == SVNEventAction.COMMIT_MODIFIED) {
            this.out.println("Sending        " + path);
            return;
        }
        if (action == SVNEventAction.COMMIT_REPLACED) {
            this.out.println("Replacing      " + path);
            return;
        }
        if (action == SVNEventAction.COMMIT_DELTA_SENT) {
            this.out.println("Transmitting file data....");
            return;
        }
        String pathChangeType = " ";
        if (action == SVNEventAction.UPDATE_ADD) {
            pathChangeType = "A";
            contentsStatus = event.getContentsStatus();
            if (contentsStatus == SVNStatusType.UNCHANGED) {
                pathChangeType = " ";
            } else if (contentsStatus == SVNStatusType.CONFLICTED) {
                pathChangeType = "C";
            } else if (contentsStatus == SVNStatusType.MERGED) {
                pathChangeType = "G";
            }
        } else if (action == SVNEventAction.UPDATE_DELETE) {
            pathChangeType = "D";
        } else if (action == SVNEventAction.UPDATE_UPDATE) {
            contentsStatus = event.getContentsStatus();
            if (contentsStatus == SVNStatusType.CHANGED) {
                pathChangeType = "U";
            } else if (contentsStatus == SVNStatusType.CONFLICTED) {
                pathChangeType = "C";
            } else if (contentsStatus == SVNStatusType.MERGED) {
                pathChangeType = "G";
            }
        } else {
            if (action == SVNEventAction.UPDATE_COMPLETED) {
                this.out.println("At revision " + event.getRevision());
                this.out.println();
                return;
            }
            if (action == SVNEventAction.ADD) {
                this.out.println("A     " + path);
                return;
            }
            if (action == SVNEventAction.DELETE) {
                this.out.println("D     " + path);
                return;
            }
            if (action == SVNEventAction.LOCKED) {
                this.out.println("L     " + path);
                return;
            }
            if (action == SVNEventAction.LOCK_FAILED) {
                this.out.println("failed to lock    " + path);
                return;
            }
        }
        SVNStatusType propertiesStatus = event.getPropertiesStatus();
        String propertiesChangeType = " ";
        if (propertiesStatus == SVNStatusType.CHANGED) {
            propertiesChangeType = "U";
        } else if (propertiesStatus == SVNStatusType.CONFLICTED) {
            propertiesChangeType = "C";
        } else if (propertiesStatus == SVNStatusType.MERGED) {
            propertiesChangeType = "G";
        }
        String lockLabel = " ";
        SVNStatusType lockType = event.getLockStatus();
        if (lockType == SVNStatusType.LOCK_UNLOCKED) {
            lockLabel = "B";
        }
        if (pathChangeType.equals(" ") && propertiesChangeType.equals(" ") && lockLabel.equals(" ")) {
            return;
        }
        this.out.println(pathChangeType + propertiesChangeType + lockLabel + "       " + path);
    }

    public String getRelativePath(File file) throws IOException {
        String inPath = file.getCanonicalPath().replace(File.separatorChar, '/');
        String basePath = this.baseDir.getCanonicalPath().replace(File.separatorChar, '/');
        String commonRoot = SubversionEventHandlerImpl.getCommonAncestor(inPath, basePath);
        String relativePath = inPath;
        if (commonRoot != null) {
            if (SubversionEventHandlerImpl.equals(inPath, commonRoot)) {
                return "";
            }
            if (SubversionEventHandlerImpl.startsWith(inPath, commonRoot + "/")) {
                relativePath = inPath.substring(commonRoot.length() + 1);
            }
        }
        if (relativePath.endsWith("/")) {
            relativePath = relativePath.substring(0, relativePath.length() - 1);
        }
        return relativePath;
    }

    private static String getCommonAncestor(String p1, String p2) {
        if (SVNFileUtil.isWindows || SVNFileUtil.isOpenVMS) {
            String ancestor = SVNPathUtil.getCommonPathAncestor((String)p1.toLowerCase(), (String)p2.toLowerCase());
            if (SubversionEventHandlerImpl.equals(ancestor, p1)) {
                return p1;
            }
            if (SubversionEventHandlerImpl.equals(ancestor, p2)) {
                return p2;
            }
            if (SubversionEventHandlerImpl.startsWith(p1, ancestor)) {
                return p1.substring(0, ancestor.length());
            }
            return ancestor;
        }
        return SVNPathUtil.getCommonPathAncestor((String)p1, (String)p2);
    }

    private static boolean startsWith(String p1, String p2) {
        if (SVNFileUtil.isWindows || SVNFileUtil.isOpenVMS) {
            return p1.toLowerCase().startsWith(p2.toLowerCase());
        }
        return p1.startsWith(p2);
    }

    private static boolean equals(String p1, String p2) {
        if (SVNFileUtil.isWindows || SVNFileUtil.isOpenVMS) {
            return p1.toLowerCase().equals(p2.toLowerCase());
        }
        return p1.equals(p2);
    }

    public static String getLocalPath(String path) {
        if ("".equals(path = path.replace('/', File.separatorChar))) {
            path = ".";
        }
        return path;
    }
}

