/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro;

import com.google.common.collect.ListMultimap;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TokenMacro
implements ExtensionPoint {
    public abstract boolean acceptsMacroName(String var1);

    public abstract String evaluate(AbstractBuild<?, ?> var1, TaskListener var2, String var3, Map<String, String> var4, ListMultimap<String, String> var5) throws MacroEvaluationException, IOException, InterruptedException;

    public boolean hasNestedContent() {
        return false;
    }

    public static ExtensionList<TokenMacro> all() {
        return Hudson.getInstance().getExtensionList(TokenMacro.class);
    }

    public static String expand(AbstractBuild<?, ?> context, TaskListener listener, String stringWithMacro) throws MacroEvaluationException, IOException, InterruptedException {
        return TokenMacro.expand(context, listener, stringWithMacro, true, null);
    }

    public static String expand(AbstractBuild<?, ?> context, TaskListener listener, String stringWithMacro, boolean throwException, List<TokenMacro> privateTokens) throws MacroEvaluationException, IOException, InterruptedException {
        if (StringUtils.isBlank((String)stringWithMacro)) {
            return stringWithMacro;
        }
        StringBuffer sb = new StringBuffer();
        Tokenizer tokenizer = new Tokenizer(stringWithMacro);
        ExtensionList<TokenMacro> all = TokenMacro.all();
        if (privateTokens != null) {
            all.addAll(privateTokens);
        }
        while (tokenizer.find()) {
            String replacement = null;
            if (tokenizer.isEscaped()) {
                replacement = tokenizer.group().substring(1);
            } else {
                String tokenName = tokenizer.getTokenName();
                ListMultimap<String, String> args = tokenizer.getArgs();
                HashMap<String, String> map = new HashMap<String, String>();
                for (Map.Entry e : args.entries()) {
                    map.put((String)e.getKey(), (String)e.getValue());
                }
                for (TokenMacro tm : all) {
                    if (!tm.acceptsMacroName(tokenName)) continue;
                    replacement = tm.evaluate(context, listener, tokenName, map, args);
                    if (!tm.hasNestedContent()) break;
                    replacement = TokenMacro.expand(context, listener, replacement, throwException, privateTokens);
                    break;
                }
                if (replacement == null && throwException) {
                    throw new MacroEvaluationException(String.format("Unrecognized macro '%s' in '%s'", tokenName, stringWithMacro));
                }
            }
            if (replacement == null && !throwException) {
                tokenizer.appendReplacement(sb, tokenizer.group());
                continue;
            }
            tokenizer.appendReplacement(sb, replacement);
        }
        tokenizer.appendTail(sb);
        return sb.toString();
    }

    public static String expandAll(AbstractBuild<?, ?> context, TaskListener listener, String stringWithMacro) throws MacroEvaluationException, IOException, InterruptedException {
        return TokenMacro.expandAll(context, listener, stringWithMacro, true, null);
    }

    public static String expandAll(AbstractBuild<?, ?> context, TaskListener listener, String stringWithMacro, boolean throwException, List<TokenMacro> privateTokens) throws MacroEvaluationException, IOException, InterruptedException {
        if (stringWithMacro == null || stringWithMacro.length() == 0) {
            return stringWithMacro;
        }
        String s = context.getEnvironment(listener).expand(stringWithMacro);
        s = Util.replaceMacro((String)s, (VariableResolver)context.getBuildVariableResolver());
        s = TokenMacro.expand(context, listener, s, throwException, privateTokens);
        return s;
    }
}

