/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Tokenizer {
    private static final String tokenNameRegex = "[a-zA-Z_][a-zA-Z0-9_]*";
    private static final String numberRegex = "-?[0-9]+(\\.[0-9]*)?";
    private static final String boolRegex = "(true)|(false)";
    private static final String stringRegex = "\"([^\\\\\"\\r\\n]|(\\\\(?:\r?\n|.)))*+\"";
    private static final String valueRegex = "(-?[0-9]+(\\.[0-9]*)?)|((true)|(false))|(\"([^\\\\\"\\r\\n]|(\\\\(?:\r?\n|.)))*+\")";
    private static final String spaceRegex = "[ \\t]*";
    private static final String argRegex = "([a-zA-Z_][a-zA-Z0-9_]*)[ \\t]*=[ \\t]*((-?[0-9]+(\\.[0-9]*)?)|((true)|(false))|(\"([^\\\\\"\\r\\n]|(\\\\(?:\r?\n|.)))*+\"))";
    private static final String argsRegex = "(([ \\t]*,[ \\t]*([a-zA-Z_][a-zA-Z0-9_]*)[ \\t]*=[ \\t]*((-?[0-9]+(\\.[0-9]*)?)|((true)|(false))|(\"([^\\\\\"\\r\\n]|(\\\\(?:\r?\n|.)))*+\")))*)";
    private static final String delimitedTokenRegex = "\\{[ \\t]*([a-zA-Z_][a-zA-Z0-9_]*)(([ \\t]*,[ \\t]*([a-zA-Z_][a-zA-Z0-9_]*)[ \\t]*=[ \\t]*((-?[0-9]+(\\.[0-9]*)?)|((true)|(false))|(\"([^\\\\\"\\r\\n]|(\\\\(?:\r?\n|.)))*+\")))*)[ \\t]*\\}";
    private static final String tokenRegex = "(\\$?)\\$(([a-zA-Z_][a-zA-Z0-9_]*)|(\\{[ \\t]*([a-zA-Z_][a-zA-Z0-9_]*)(([ \\t]*,[ \\t]*([a-zA-Z_][a-zA-Z0-9_]*)[ \\t]*=[ \\t]*((-?[0-9]+(\\.[0-9]*)?)|((true)|(false))|(\"([^\\\\\"\\r\\n]|(\\\\(?:\r?\n|.)))*+\")))*)[ \\t]*\\}))";
    private static final Pattern argPattern = Pattern.compile("([a-zA-Z_][a-zA-Z0-9_]*)[ \\t]*=[ \\t]*((-?[0-9]+(\\.[0-9]*)?)|((true)|(false))|(\"([^\\\\\"\\r\\n]|(\\\\(?:\r?\n|.)))*+\"))");
    private static final Pattern tokenPattern = Pattern.compile("(\\$?)\\$(([a-zA-Z_][a-zA-Z0-9_]*)|(\\{[ \\t]*([a-zA-Z_][a-zA-Z0-9_]*)(([ \\t]*,[ \\t]*([a-zA-Z_][a-zA-Z0-9_]*)[ \\t]*=[ \\t]*((-?[0-9]+(\\.[0-9]*)?)|((true)|(false))|(\"([^\\\\\"\\r\\n]|(\\\\(?:\r?\n|.)))*+\")))*)[ \\t]*\\}))");
    private static final String ESCAPE_STRING = "$$";
    private final Matcher tokenMatcher;
    private String tokenName = null;
    private ListMultimap<String, String> args = null;

    Tokenizer(String origText) {
        this.tokenMatcher = tokenPattern.matcher(origText);
    }

    String getTokenName() {
        return this.tokenName;
    }

    ListMultimap<String, String> getArgs() {
        return this.args;
    }

    String group() {
        return this.tokenMatcher.group();
    }

    boolean isEscaped() {
        return this.tokenMatcher.group().startsWith(ESCAPE_STRING);
    }

    boolean find() {
        if (this.tokenMatcher.find()) {
            if (this.isEscaped()) {
                return true;
            }
            this.tokenName = this.tokenMatcher.group(3);
            if (this.tokenName == null) {
                this.tokenName = this.tokenMatcher.group(5);
            }
            this.args = Multimaps.newListMultimap(new TreeMap(), (Supplier)new Supplier<List<String>>(){

                public List<String> get() {
                    return new ArrayList<String>();
                }
            });
            if (this.tokenMatcher.group(6) != null) {
                Tokenizer.parseArgs(this.tokenMatcher.group(6), this.args);
            }
            return true;
        }
        return false;
    }

    static void parseArgs(String argsString, ListMultimap<String, String> args) {
        Matcher argMatcher = argPattern.matcher(argsString);
        while (argMatcher.find()) {
            String arg = argMatcher.group(3) != null ? argMatcher.group(3) : (argMatcher.group(5) != null ? (argMatcher.group(6) != null ? "true" : "false") : Tokenizer.unescapeString(argMatcher.group(8)));
            args.put((Object)argMatcher.group(1), (Object)arg);
        }
    }

    void appendReplacement(StringBuffer sb, String replacement) {
        this.tokenMatcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
    }

    void appendTail(StringBuffer sb) {
        this.tokenMatcher.appendTail(sb);
    }

    public static String unescapeString(String escapedString) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < escapedString.length() - 1; ++i) {
            char c = escapedString.charAt(i);
            if (c == '\\') {
                sb.append(Tokenizer.unescapeChar(escapedString.charAt(++i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static char unescapeChar(char escapedChar) {
        switch (escapedChar) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
        }
        return escapedChar;
    }
}

