/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public final class LogRegExMacro
extends DataBoundTokenMacro {
    private static final String MACRO_NAME = "LOG_REGEX";
    @DataBoundTokenMacro.Parameter(required=true)
    public String regex = null;
    @DataBoundTokenMacro.Parameter(required=true)
    public String replacement = null;

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.readLogFile(context.getLogFile());
    }

    public String readLogFile(File file) throws IOException {
        String line;
        if (this.regex == null) {
            return "";
        }
        Pattern pattern = Pattern.compile(this.regex);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            return this.getTranslatedDescription(matcher);
        }
        return "";
    }

    private String getTranslatedDescription(Matcher matcher) {
        String result = this.replacement;
        if (result == null) {
            result = matcher.groupCount() == 0 ? "\\0" : "\\1";
        }
        for (int i = matcher.groupCount(); i >= 0; --i) {
            result = result.replace("\\" + i, matcher.group(i) == null ? "" : matcher.group(i));
        }
        return result;
    }
}

