/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

@Extension
public class EnvironmentVariableMacro
extends DataBoundTokenMacro {
    public static final String MACRO_NAME = "ENV";
    @DataBoundTokenMacro.Parameter(required=true)
    public String var = "";
    @DataBoundTokenMacro.Parameter(alias="default")
    public String def = "";

    @Override
    public List<String> getAcceptedMacroNames() {
        return Collections.singletonList(MACRO_NAME);
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)context, null, listener, macroName);
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private String getEnvVarFromWorkflowRun(Run<?, ?> run) {
        try {
            List actualExecutions;
            StepContext context;
            Map vars;
            WorkflowRun workflowRun = (WorkflowRun)run;
            FlowExecution execution = workflowRun.getExecution();
            if (execution != null && (vars = (Map)(context = ((StepExecution)(actualExecutions = (List)execution.getCurrentExecutions(true).get()).get(0)).getContext()).get(EnvVars.class)) != null && vars.containsKey(this.var)) {
                return (String)vars.get(this.var);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @Override
    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        EnvVars env;
        String res = "";
        if (Jenkins.get().getPlugin("workflow-job") != null) {
            res = this.getEnvVarFromWorkflowRun(run);
        }
        if (StringUtils.isBlank((CharSequence)res) && (env = run.getEnvironment(listener)).containsKey(this.var)) {
            return (String)env.get(this.var);
        }
        if (StringUtils.isBlank((CharSequence)res) && StringUtils.isNotBlank((CharSequence)this.def)) {
            res = this.def;
        }
        return res;
    }

    @Override
    public boolean acceptsMacroName(String macroName) {
        return MACRO_NAME.equals(macroName);
    }
}

