/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.transform;

import edu.umd.cs.findbugs.annotations.NonNull;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.Transform;

public class SubstringTransform
extends Transform {
    private int offset;
    private int length;

    public SubstringTransform(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    @Override
    public String transform(@NonNull String input) throws MacroEvaluationException {
        if (this.offset > input.length()) {
            throw new MacroEvaluationException(String.format("Offset given (%d) is larger than the string", this.offset));
        }
        if (this.offset < 0) {
            this.offset = input.length() + this.offset;
        }
        if (this.length == Integer.MAX_VALUE) {
            input = input.substring(this.offset);
        } else {
            if (this.length < 0) {
                this.length = input.length() + this.length - this.offset;
            }
            if (this.offset + this.length > input.length()) {
                throw new MacroEvaluationException(String.format("Incorrect offset or length: input length is %d and offset end is %d", input.length(), this.offset + this.length));
            }
            input = input.substring(this.offset, this.offset + this.length);
        }
        return input;
    }
}

