/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ws_cleanup;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.ws_cleanup.Messages;
import hudson.plugins.ws_cleanup.Pattern;
import hudson.plugins.ws_cleanup.RemoteCleaner;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class PreBuildCleanup
extends BuildWrapper {
    private static final Logger LOGGER = Logger.getLogger(PreBuildCleanup.class.getName());
    private final List<Pattern> patterns;
    private final boolean deleteDirs;
    private final String cleanupParameter;
    private final String externalDelete;
    private final boolean disableDeferredWipeout;

    @Deprecated
    public PreBuildCleanup(List<Pattern> patterns, boolean deleteDirs, String cleanupParameter, String externalDelete) {
        this(patterns, deleteDirs, cleanupParameter, externalDelete, false);
    }

    @DataBoundConstructor
    public PreBuildCleanup(List<Pattern> patterns, boolean deleteDirs, String cleanupParameter, String externalDelete, boolean disableDeferredWipeout) {
        this.patterns = patterns;
        this.deleteDirs = deleteDirs;
        this.cleanupParameter = cleanupParameter;
        this.externalDelete = externalDelete;
        this.disableDeferredWipeout = disableDeferredWipeout;
    }

    public List<Pattern> getPatterns() {
        return this.patterns;
    }

    public boolean getDeleteDirs() {
        return this.deleteDirs;
    }

    public String getCleanupParameter() {
        return this.cleanupParameter;
    }

    public String getExternalDelete() {
        return this.externalDelete;
    }

    public boolean getDisableDeferredWipeout() {
        return this.disableDeferredWipeout;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) {
        return new NoopEnv();
    }

    public void preCheckout(AbstractBuild build, Launcher launcher, BuildListener listener) throws AbortException {
        boolean doCleanup;
        if (this.cleanupParameter != null && !this.cleanupParameter.isEmpty() && !(doCleanup = Boolean.parseBoolean((String)build.getBuildVariables().get(this.cleanupParameter)))) {
            listener.getLogger().println("[WS-CLEANUP] Clean-up disabled, skipping workspace deletion.");
            return;
        }
        FilePath ws = build.getWorkspace();
        if (ws != null) {
            listener.getLogger().println("[WS-CLEANUP] Deleting project workspace...");
            RemoteCleaner cleaner = RemoteCleaner.get(this.patterns, this.deleteDirs, this.externalDelete, (TaskListener)listener, build, this.disableDeferredWipeout);
            try {
                int retry = 3;
                while (true) {
                    try {
                        if (!ws.exists()) {
                            return;
                        }
                        cleaner.perform(ws);
                        listener.getLogger().println("[WS-CLEANUP] Done");
                    }
                    catch (IOException e) {
                        if (--retry > 0) {
                            Thread.sleep(3000L);
                            continue;
                        }
                        listener.error("[WS-CLEANUP] Cannot delete workspace: " + e.getMessage());
                        LOGGER.log(Level.SEVERE, "Cannot delete workspace", e);
                        throw new AbortException("Cannot delete workspace: " + e.getMessage());
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, "Cleanup interrupted", e);
                Thread.currentThread().interrupt();
            }
        }
    }

    @Extension(ordinal=9999.0)
    public static final class DescriptorImpl
    extends Descriptor<BuildWrapper> {
        @NonNull
        public String getDisplayName() {
            return Messages.PreBuildCleanup_Delete_workspace();
        }
    }

    class NoopEnv
    extends BuildWrapper.Environment {
        NoopEnv() {
            super((BuildWrapper)PreBuildCleanup.this);
        }
    }
}

