/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ws_cleanup;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.plugins.ws_cleanup.RemoteCleaner;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.resourcedisposer.AsyncResourceDisposer;
import org.jenkinsci.plugins.resourcedisposer.Disposable;

class Wipeout
extends RemoteCleaner {
    static Wipeout INSTANCE = new Wipeout();
    private static final Logger LOGGER = Logger.getLogger(Wipeout.class.getName());

    Wipeout() {
    }

    static Wipeout getInstance() {
        return INSTANCE;
    }

    @Override
    protected void perform(FilePath workspace) throws IOException, InterruptedException {
        FilePath deleteMe = workspace.withSuffix("_ws-cleanup_" + System.currentTimeMillis());
        Computer computer = workspace.toComputer();
        if (computer == null) {
            this.performDelete(workspace);
            return;
        }
        String errmsg = "Cleaning workspace synchronously. Failed to rename " + workspace.getRemote() + " to " + deleteMe.getName() + ".";
        try {
            workspace.renameTo(deleteMe);
        }
        catch (FileSystemException expected) {
            errmsg = errmsg + " " + expected;
        }
        if (deleteMe.exists()) {
            AsyncResourceDisposer.get().dispose(new Disposable[]{new DisposableImpl(deleteMe, computer.getName())});
            return;
        }
        LOGGER.log(Level.WARNING, errmsg);
        this.performDelete(workspace);
    }

    void performDelete(FilePath workspace) throws IOException, InterruptedException {
        workspace.deleteRecursive();
    }

    private static final class DisposableImpl
    implements Disposable {
        private static final long serialVersionUID = 1L;
        private final String node;
        private final String path;

        private DisposableImpl(FilePath ws, String computer) {
            this.node = computer;
            this.path = ws.getRemote();
        }

        @NonNull
        public Disposable.State dispose() throws Throwable {
            Jenkins j = Jenkins.getInstanceOrNull();
            if (j == null) {
                return Disposable.State.TO_DISPOSE;
            }
            Computer computer = j.getComputer(this.node);
            if (computer == null) {
                return Disposable.State.PURGED;
            }
            FilePath ws = new FilePath(computer.getChannel(), this.path);
            try {
                INSTANCE.performDelete(ws);
            }
            catch (IOException ex) {
                Throwable cause = ex.getCause();
                if (cause != null && ex.getMessage().startsWith("remote file operation failed:")) {
                    throw cause;
                }
                throw ex;
            }
            return ws.exists() ? Disposable.State.TO_DISPOSE : Disposable.State.PURGED;
        }

        @NonNull
        public String getDisplayName() {
            return "Workspace " + (this.node.isEmpty() ? "master" : this.node) + ":" + this.path;
        }
    }
}

