/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.utils.process;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.apache.commons.io.IOUtils;

public class ProcessInputStream
extends InputStream {
    private final Process process;
    private final InputStream base;
    private String displayName;

    public ProcessInputStream(Process p) {
        this.process = p;
        this.base = this.process.getInputStream();
    }

    ProcessInputStream withDisplayName(String n) {
        this.displayName = n;
        return this;
    }

    @Override
    public int read() throws IOException {
        return this.base.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.base.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.base.read(b, off, len);
    }

    public InputStream getInputStream() {
        return this.base;
    }

    public Process getProcess() {
        return this.process;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.base.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.base.available();
    }

    @Override
    public void close() throws IOException {
        this.base.close();
    }

    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    public String asText() throws IOException, InterruptedException {
        String r = IOUtils.toString((InputStream)this);
        this.waitFor();
        return r;
    }

    public String verifyOrDieWith(String errorMessage) throws IOException, InterruptedException {
        String text = this.asText();
        if (this.waitFor() == 0) {
            return text;
        }
        throw new IOException(errorMessage + "\n" + text);
    }

    public InputStream withErrorCheck() {
        return new FilterInputStream(this){

            @Override
            public int read() throws IOException {
                return this.check(super.read());
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.check(super.read(b));
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return this.check(super.read(b, off, len));
            }

            private int check(int r) throws IOException {
                if (r < 0) {
                    try {
                        int x = ProcessInputStream.this.waitFor();
                        if (x != 0) {
                            String n = ProcessInputStream.this.displayName;
                            if (n == null) {
                                n = ProcessInputStream.this.process.toString();
                            }
                            throw new IOException("Process '" + n + "' terminated with exit code=" + x);
                        }
                    }
                    catch (InterruptedException e) {
                        throw (IOException)new InterruptedIOException().initCause(e);
                    }
                }
                return r;
            }
        };
    }
}

