/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class Artifacts
extends ArrayList<Artifact> {
    public Artifacts() {
    }

    public Artifacts(Collection<? extends Artifact> c) {
        super(c);
    }

    public static Artifacts of(MavenProject p) {
        return new Artifacts(p.getArtifacts());
    }

    public static Artifacts ofDirectDependencies(MavenProject p) {
        return new Artifacts(p.getDependencyArtifacts());
    }

    public Artifacts retainAll(Predicate<Artifact> filter) {
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            if (filter.apply(itr.next())) continue;
            itr.remove();
        }
        return this;
    }

    public Artifacts removeAll(Predicate<Artifact> filter) {
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            if (!filter.apply(itr.next())) continue;
            itr.remove();
        }
        return this;
    }

    public Artifacts scopeIs(String ... scopes) {
        final List<String> s = Arrays.asList(scopes);
        return this.retainAll(new Predicate<Artifact>(){

            public boolean apply(Artifact a) {
                return s.contains(a.getScope());
            }
        });
    }

    public Artifacts scopeIsNot(String ... scopes) {
        final List<String> s = Arrays.asList(scopes);
        return this.removeAll(new Predicate<Artifact>(){

            public boolean apply(Artifact a) {
                return s.contains(a.getScope());
            }
        });
    }

    public Artifacts typeIs(String ... type) {
        final List<String> s = Arrays.asList(type);
        return this.retainAll(new Predicate<Artifact>(){

            public boolean apply(Artifact a) {
                return s.contains(a.getType());
            }
        });
    }

    public Artifacts typeIsNot(String ... type) {
        final List<String> s = Arrays.asList(type);
        return this.removeAll(new Predicate<Artifact>(){

            public boolean apply(Artifact a) {
                return s.contains(a.getType());
            }
        });
    }

    public Artifacts groupIdIs(String ... groupId) {
        final List<String> s = Arrays.asList(groupId);
        return this.retainAll(new Predicate<Artifact>(){

            public boolean apply(Artifact a) {
                return s.contains(a.getType());
            }
        });
    }

    public Artifacts groupIdIsNot(String ... groupId) {
        final List<String> s = Arrays.asList(groupId);
        return this.removeAll(new Predicate<Artifact>(){

            public boolean apply(Artifact a) {
                return s.contains(a.getType());
            }
        });
    }

    public Artifacts artifactIdIs(String ... artifactId) {
        final List<String> s = Arrays.asList(artifactId);
        return this.retainAll(new Predicate<Artifact>(){

            public boolean apply(Artifact a) {
                return s.contains(a.getType());
            }
        });
    }

    public Artifacts artifactIdIsNot(String ... artifactId) {
        final List<String> s = Arrays.asList(artifactId);
        return this.removeAll(new Predicate<Artifact>(){

            public boolean apply(Artifact a) {
                return s.contains(a.getType());
            }
        });
    }
}

