/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jenkinsci.maven.plugins.hpi.AbstractHpiMojo;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;

@Mojo(name="resolve-test-dependencies", requiresDependencyResolution=ResolutionScope.TEST)
public class TestDependencyMojo
extends AbstractHpiMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        File testDir = new File(this.project.getBuild().getTestOutputDirectory(), "test-dependencies");
        testDir.mkdirs();
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(testDir, "index")), "UTF-8");
            for (MavenArtifact a : this.getProjectArtfacts()) {
                if (!a.isPluginBestEffort(this.getLog())) continue;
                String artifactId = a.getActualArtifactId();
                if (artifactId == null) {
                    this.getLog().debug((CharSequence)("Skipping " + artifactId + " with classifier " + a.getClassifier()));
                    continue;
                }
                this.getLog().debug((CharSequence)("Copying " + artifactId + " as a test dependency"));
                File dst = new File(testDir, artifactId + ".hpi");
                FileUtils.copyFile((File)a.getHpi().getFile(), (File)dst);
                w.write(artifactId + "\n");
            }
            ((Writer)w).close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy dependency plugins", (Exception)e);
        }
    }
}

