/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import com.google.common.collect.Sets;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jenkinsci.maven.plugins.hpi.AbstractHpiMojo;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;

@Mojo(name="validate-hpi", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
public class ValidateHpiMojo
extends AbstractHpiMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        VersionNumber coreVersion = new VersionNumber(this.findJenkinsVersion());
        MavenArtifact maxCoreVersionArtifact = null;
        VersionNumber maxCoreVersion = new VersionNumber("0");
        for (MavenArtifact artifact : Sets.union(this.getProjectArtfacts(), this.getDirectDependencyArtfacts())) {
            try {
                VersionNumber dependencyCoreVersion;
                if (!artifact.isPluginBestEffort(this.getLog()) || (dependencyCoreVersion = this.getDependencyCoreVersion(artifact)).compareTo(maxCoreVersion) <= 0) continue;
                maxCoreVersionArtifact = artifact;
                maxCoreVersion = dependencyCoreVersion;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to retrieve manifest, artifactId: " + artifact.getArtifactId(), (Exception)e);
            }
        }
        if (coreVersion.compareTo(maxCoreVersion) < 0) {
            throw new MojoExecutionException("Dependency " + maxCoreVersionArtifact + " requires Jenkins " + maxCoreVersion + " or higher.");
        }
    }

    private VersionNumber getDependencyCoreVersion(MavenArtifact artifact) throws IOException, MojoExecutionException {
        File file = artifact.getFile();
        if (file.isFile()) {
            Attributes mainAttributes;
            try (JarFile jarFile = new JarFile(file);){
                mainAttributes = jarFile.getManifest().getMainAttributes();
            }
            Attributes.Name jName = new Attributes.Name("Jenkins-Version");
            if (mainAttributes.containsKey(jName)) {
                return new VersionNumber(mainAttributes.getValue(jName));
            }
            Attributes.Name hName = new Attributes.Name("Hudson-Version");
            if (mainAttributes.containsKey(hName)) {
                return new VersionNumber(mainAttributes.getValue(hName));
            }
            throw new MojoExecutionException("Could not find Jenkins Version in manifest for " + artifact);
        }
        this.getLog().warn((CharSequence)("Skipping jenkins-core validation for " + artifact + " since we rely on sources and don't have a manifest. Use 'package' goal to get validation"));
        return new VersionNumber(this.findJenkinsVersion());
    }
}

