/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.apache.maven.archiver.ManifestConfiguration;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.jenkinsci.maven.plugins.hpi.AbstractHpiMojo;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;

public abstract class AbstractJenkinsManifestMojo
extends AbstractHpiMojo {
    private static final Logger LOGGER = Logger.getLogger(AbstractJenkinsManifestMojo.class.getName());
    @Parameter(property="hpi.compatibleSinceVersion")
    private String compatibleSinceVersion;
    @Parameter
    private String sandboxStatus;
    @Deprecated
    @Parameter
    protected String minimumJavaVersion;

    protected void generateManifest(MavenArchiveConfiguration archive, File manifestFile) throws MojoExecutionException {
        if (!Files.isDirectory(manifestFile.toPath().getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(manifestFile.toPath().getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to create parent directories for '" + manifestFile + "'", (Exception)e);
            }
        }
        this.getLog().info((CharSequence)("Generating " + manifestFile));
        MavenArchiver ma = new MavenArchiver();
        ma.setOutputFile(manifestFile);
        try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(manifestFile), StandardCharsets.UTF_8));){
            ManifestConfiguration config = archive.getManifest();
            config.setAddDefaultSpecificationEntries(true);
            config.setAddDefaultImplementationEntries(true);
            Manifest mf = ma.getManifest(this.project, config);
            Manifest.ExistingSection mainSection = mf.getMainSection();
            this.setAttributes(mainSection);
            mf.write((Writer)printWriter);
        }
        catch (IOException | DependencyResolutionRequiredException | ManifestException e) {
            throw new MojoExecutionException("Error preparing the manifest: " + e.getMessage(), (Exception)e);
        }
    }

    protected void setAttributes(Manifest.ExistingSection mainSection) throws MojoExecutionException, ManifestException, IOException {
        Boolean b;
        String dep;
        String v;
        File pluginImpl = new File(this.project.getBuild().getOutputDirectory(), "META-INF/services/hudson.Plugin");
        if (pluginImpl.exists()) {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(pluginImpl), StandardCharsets.UTF_8));
            String pluginClassName = in.readLine();
            in.close();
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Plugin-Class", pluginClassName));
        }
        mainSection.addAttributeAndCheck(new Manifest.Attribute("Group-Id", this.project.getGroupId()));
        mainSection.addAttributeAndCheck(new Manifest.Attribute("Short-Name", this.project.getArtifactId()));
        mainSection.addAttributeAndCheck(new Manifest.Attribute("Long-Name", this.pluginName));
        String url = this.project.getUrl();
        if (url != null) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Url", url));
        }
        if (this.compatibleSinceVersion != null) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Compatible-Since-Version", this.compatibleSinceVersion));
        }
        if (this.minimumJavaVersion != null && !this.minimumJavaVersion.isEmpty()) {
            this.getLog().warn((CharSequence)"Ignoring deprecated minimumJavaVersion parameter. This property should be removed from your plugin's POM. In the future this warning will be changed to an error and will break the build.");
        }
        if (this.sandboxStatus != null) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Sandbox-Status", this.sandboxStatus));
        }
        if ((v = this.project.getVersion()).endsWith("-SNAPSHOT") && this.snapshotPluginVersionOverride != null) {
            String nonSnapshotVersion = v.substring(0, v.length() - "-SNAPSHOT".length());
            if (!this.snapshotPluginVersionOverride.startsWith(nonSnapshotVersion)) {
                String message = "The snapshotPluginVersionOverride of " + this.snapshotPluginVersionOverride + " does not start with the current target release version " + v;
                if (this.failOnVersionOverrideToDifferentRelease) {
                    throw new MojoExecutionException(message);
                }
                this.getLog().warn((CharSequence)message);
            }
            this.getLog().info((CharSequence)("Snapshot Plugin Version Override enabled. Using " + this.snapshotPluginVersionOverride + " in place of " + v));
            v = this.snapshotPluginVersionOverride;
        }
        if (v.endsWith("-SNAPSHOT") && this.pluginVersionDescription == null) {
            String dt = this.getGitHeadSha1();
            if (dt == null) {
                dt = new SimpleDateFormat("MM/dd/yyyy HH:mm").format(new Date());
            }
            this.pluginVersionDescription = "private-" + dt + "-" + System.getProperty("user.name");
        }
        if (this.pluginVersionDescription != null) {
            v = v + " (" + this.pluginVersionDescription + ")";
        }
        if (!this.project.getPackaging().equals("jenkins-module")) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Plugin-Version", v));
        }
        String jv = this.findJenkinsVersion();
        mainSection.addAttributeAndCheck(new Manifest.Attribute("Hudson-Version", jv));
        mainSection.addAttributeAndCheck(new Manifest.Attribute("Jenkins-Version", jv));
        if (this.maskClasses != null) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Mask-Classes", this.maskClasses));
        }
        if (this.globalMaskClasses != null) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Global-Mask-Classes", this.globalMaskClasses));
        }
        if (this.pluginFirstClassLoader) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("PluginFirstClassLoader", "true"));
        }
        if ((dep = this.findDependencyPlugins()).length() > 0) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Plugin-Dependencies", dep));
        }
        if (this.project.getDevelopers() != null) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Plugin-Developers", this.getDevelopersForManifest()));
        }
        if ((b = this.isSupportDynamicLoading()) != null) {
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Support-Dynamic-Loading", b.toString()));
        }
        this.addLicenseAttributesForManifest(mainSection);
        this.addPropertyAttributeIfNotNull(mainSection, "Plugin-ChangelogUrl", "hpi.pluginChangelogUrl");
        this.addPropertyAttributeIfNotNull(mainSection, "Plugin-LogoUrl", "hpi.pluginLogoUrl");
        this.addAttributeIfNotNull(mainSection, "Plugin-ScmUrl", this.getScmUrl());
    }

    private String findDependencyPlugins() throws IOException, MojoExecutionException {
        StringBuilder buf = new StringBuilder();
        for (MavenArtifact a : this.getDirectDependencyArtfacts()) {
            if (!a.isPlugin() || !this.scopeFilter.include(a.artifact) || a.hasSameGAAs(this.project)) continue;
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(a.getActualArtifactId());
            buf.append(':');
            buf.append(a.getActualVersion());
            if (!a.isOptional()) continue;
            buf.append(";resolution:=optional");
        }
        for (MavenArtifact a : this.project.getDependencyArtifacts()) {
            if (!"provided".equals(a.getScope()) || !this.wrap((Artifact)a).isPlugin()) continue;
            throw new MojoExecutionException(a.getId() + " is marked as 'provided' scope dependency, but it should be the 'compile' scope.");
        }
        return buf.toString();
    }

    private String getDevelopersForManifest() throws IOException {
        StringBuilder buf = new StringBuilder();
        for (Developer d : this.project.getDevelopers()) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(d.getName() != null ? d.getName() : "");
            buf.append(':');
            buf.append(d.getId() != null ? d.getId() : "");
            buf.append(':');
            buf.append(d.getEmail() != null ? d.getEmail() : "");
        }
        return buf.toString();
    }

    protected Manifest loadManifest(File f) throws IOException, ManifestException {
        try (InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);){
            Manifest manifest = new Manifest(is);
            return manifest;
        }
    }

    private void addLicenseAttributesForManifest(Manifest.ExistingSection target) throws ManifestException {
        List licenses = this.project.getLicenses();
        int licenseCounter = 1;
        for (License lic : licenses) {
            String licenseSuffix = licenseCounter == 1 ? "" : "-" + licenseCounter;
            this.addAttributeIfNotNull(target, "Plugin-License-Name" + licenseSuffix, lic.getName());
            this.addAttributeIfNotNull(target, "Plugin-License-Url" + licenseSuffix, lic.getUrl());
            ++licenseCounter;
        }
    }

    private String getScmUrl() {
        Scm scm = this.project.getScm();
        if (scm != null) {
            return scm.getUrl();
        }
        return null;
    }

    private void addAttributeIfNotNull(Manifest.ExistingSection target, String attributeName, String propertyValue) throws ManifestException {
        if (propertyValue != null) {
            target.addAttributeAndCheck(new Manifest.Attribute(attributeName, propertyValue));
        }
    }

    private void addPropertyAttributeIfNotNull(Manifest.ExistingSection target, String attributeName, String propertyName) throws ManifestException {
        String propertyValue = this.project.getProperties().getProperty(propertyName);
        if (propertyValue != null) {
            target.addAttributeAndCheck(new Manifest.Attribute(attributeName, propertyValue));
        }
    }
}

