/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class Artifacts
extends ArrayList<Artifact> {
    public Artifacts() {
    }

    public Artifacts(Collection<? extends Artifact> c) {
        super(c);
    }

    public static Artifacts of(MavenProject p) {
        return new Artifacts(p.getArtifacts());
    }

    public static Artifacts ofDirectDependencies(MavenProject p) {
        return new Artifacts(p.getDependencyArtifacts());
    }

    public Artifacts retainAll(Predicate<Artifact> filter) {
        this.removeIf(artifact -> !filter.test((Artifact)artifact));
        return this;
    }

    public Artifacts removeAll(Predicate<Artifact> filter) {
        this.removeIf(filter);
        return this;
    }

    public Artifacts scopeIs(String ... scopes) {
        List<String> s = Arrays.asList(scopes);
        return this.retainAll((Artifact a) -> s.contains(a.getScope()));
    }

    public Artifacts scopeIsNot(String ... scopes) {
        List<String> s = Arrays.asList(scopes);
        return this.removeAll((Artifact a) -> s.contains(a.getScope()));
    }

    public Artifacts typeIs(String ... type) {
        List<String> s = Arrays.asList(type);
        return this.retainAll((Artifact a) -> s.contains(a.getType()));
    }

    public Artifacts typeIsNot(String ... type) {
        List<String> s = Arrays.asList(type);
        return this.removeAll((Artifact a) -> s.contains(a.getType()));
    }

    public Artifacts groupIdIs(String ... groupId) {
        List<String> s = Arrays.asList(groupId);
        return this.retainAll((Artifact a) -> s.contains(a.getType()));
    }

    public Artifacts groupIdIsNot(String ... groupId) {
        List<String> s = Arrays.asList(groupId);
        return this.removeAll((Artifact a) -> s.contains(a.getType()));
    }

    public Artifacts artifactIdIs(String ... artifactId) {
        List<String> s = Arrays.asList(artifactId);
        return this.retainAll((Artifact a) -> s.contains(a.getType()));
    }

    public Artifacts artifactIdIsNot(String ... artifactId) {
        List<String> s = Arrays.asList(artifactId);
        return this.removeAll((Artifact a) -> s.contains(a.getType()));
    }
}

