/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import com.google.common.io.ByteStreams;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.util.VersionNumber;
import io.jenkins.lib.versionnumber.JavaSpecificationVersion;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.jenkinsci.maven.plugins.hpi.AbstractJenkinsMojo;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;

@Mojo(name="test-runtime", requiresDependencyResolution=ResolutionScope.TEST)
public class TestRuntimeMojo
extends AbstractJenkinsMojo {
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skipTests || this.skip) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return;
        }
        this.setAddOpensProperty();
        this.setInsaneHookProperty();
    }

    private void setAddOpensProperty() throws MojoExecutionException {
        if (JavaSpecificationVersion.forCurrentJVM().isOlderThan((VersionNumber)new JavaSpecificationVersion("9"))) {
            return;
        }
        String manifestEntry = TestRuntimeMojo.getManifestEntry(this.wrap(this.resolveJenkinsWar()));
        if (manifestEntry == null) {
            return;
        }
        String argLine = TestRuntimeMojo.buildArgLine(manifestEntry);
        this.getLog().info((CharSequence)("Setting jenkins.addOpens to " + argLine));
        this.project.getProperties().setProperty("jenkins.addOpens", argLine);
    }

    @NonNull
    private Artifact resolveJenkinsWar() throws MojoExecutionException {
        DefaultArtifactCoordinate artifactCoordinate = new DefaultArtifactCoordinate();
        artifactCoordinate.setGroupId("org.jenkins-ci.main");
        artifactCoordinate.setArtifactId("jenkins-war");
        artifactCoordinate.setVersion(this.findJenkinsVersion());
        artifactCoordinate.setExtension("war");
        try {
            return this.artifactResolver.resolveArtifact(this.session.getProjectBuildingRequest(), (ArtifactCoordinate)artifactCoordinate).getArtifact();
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException("Couldn't download artifact: ", (Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    private static String getManifestEntry(MavenArtifact artifact) throws MojoExecutionException {
        File war = artifact.getFile();
        try (JarFile jarFile = new JarFile(war);){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                throw new MojoExecutionException("No manifest found in " + war);
            }
            String string = manifest.getMainAttributes().getValue("Add-Opens");
            return string;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read MANIFEST.MF from " + war, (Exception)e);
        }
    }

    @NonNull
    private static String buildArgLine(String manifestEntry) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (String module : manifestEntry.split("\\s+")) {
            if (module.isEmpty()) continue;
            arguments.add("--add-opens");
            arguments.add(module + "=ALL-UNNAMED");
        }
        return String.join((CharSequence)" ", arguments);
    }

    private void setInsaneHookProperty() throws MojoExecutionException {
        Artifact insane = (Artifact)this.project.getArtifactMap().get("org.netbeans.modules:org-netbeans-insane");
        if (insane == null || Integer.parseInt(insane.getVersion().substring("RELEASE".length())) < 130) {
            return;
        }
        Artifact jth = (Artifact)this.project.getArtifactMap().get("org.jenkins-ci.main:jenkins-test-harness");
        if (jth == null) {
            return;
        }
        Path insaneHook = TestRuntimeMojo.getInsaneHook(this.wrap(jth));
        String argLine = JavaSpecificationVersion.forCurrentJVM().isNewerThanOrEqualTo((VersionNumber)new JavaSpecificationVersion("9")) ? String.format("--patch-module=java.base=%s --add-exports=java.base/org.netbeans.insane.hook=ALL-UNNAMED", insaneHook) : String.format("-Xbootclasspath/p:%s", insaneHook);
        this.getLog().info((CharSequence)("Setting jenkins.insaneHook to " + argLine));
        this.project.getProperties().setProperty("jenkins.insaneHook", argLine);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private static Path getInsaneHook(MavenArtifact artifact) throws MojoExecutionException {
        File jar = artifact.getFile();
        try (JarFile jarFile = new JarFile(jar);){
            ZipEntry entry = jarFile.getEntry("netbeans/harness/modules/ext/org-netbeans-insane-hook.jar");
            if (entry == null) {
                throw new MojoExecutionException("Failed to find org-netbeans-insane-hook.jar in " + jar);
            }
            Path tempFile = Files.createTempFile("org-netbeans-insane-hook", ".jar", new FileAttribute[0]);
            tempFile.toFile().deleteOnExit();
            try (InputStream is = jarFile.getInputStream(entry);
                 OutputStream os = Files.newOutputStream(tempFile, new OpenOption[0]);){
                ByteStreams.copy((InputStream)is, (OutputStream)os);
            }
            Path path = tempFile.toAbsolutePath();
            return path;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read org-netbeans-insane-hook.jar from " + jar, (Exception)e);
        }
    }
}

