/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import hudson.util.VersionNumber;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jenkinsci.maven.plugins.hpi.AbstractJenkinsMojo;

@Mojo(name="insert-test", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class TestInsertionMojo
extends AbstractJenkinsMojo {
    @Parameter(property="maven-hpi-plugin.disabledTestInjection", defaultValue="false")
    private boolean disabledTestInjection;
    @Parameter(property="maven-hpi-plugin.injectedTestName", defaultValue="InjectedTest")
    private String injectedTestName;
    @Parameter(property="jelly.requirePI", defaultValue="true")
    private boolean requirePI;
    @Parameter(defaultValue="org.jenkins-ci.main:jenkins-test-harness")
    protected String jenkinsTestHarnessId;

    private static String quote(String s) {
        return "\"" + s.replace("\\", "\\\\") + "\"";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        block20: {
            if (!this.project.getPackaging().equals("hpi")) {
                Artifact jenkinsTestHarness = null;
                if (this.jenkinsTestHarnessId != null) {
                    for (Artifact b : this.project.getTestArtifacts()) {
                        if (!this.jenkinsTestHarnessId.equals(b.getGroupId() + ":" + b.getArtifactId())) continue;
                        jenkinsTestHarness = b;
                        break;
                    }
                }
                if (jenkinsTestHarness != null) {
                    try {
                        ArtifactVersion version = jenkinsTestHarness.getSelectedVersion();
                        if (version == null || version.compareTo((Object)new DefaultArtifactVersion("2.14")) < 0) {
                            this.getLog().info((CharSequence)("Skipping " + this.project.getName() + " because it's not <packaging>hpi</packaging> and the " + this.jenkinsTestHarnessId + ", " + version + ", is less than 2.14"));
                            return;
                        }
                        break block20;
                    }
                    catch (OverConstrainedVersionException e) {
                        throw new MojoFailureException("Build should be failed before we get here if there is an over-constrained version", (Throwable)e);
                    }
                }
                this.getLog().info((CharSequence)("Skipping " + this.project.getName() + " because it's not <packaging>hpi</packaging> and we could not determine the version of " + this.jenkinsTestHarnessId + " used by this project"));
                return;
            }
        }
        if (this.disabledTestInjection) {
            this.getLog().info((CharSequence)"Skipping auto-test generation");
            return;
        }
        String target = this.findJenkinsVersion();
        if (new VersionNumber(target).compareTo(new VersionNumber("1.327")) < 0) {
            this.getLog().info((CharSequence)("Skipping auto-test generation because we are targeting Jenkins " + target + " (at least 1.327 is required)."));
            return;
        }
        File f = new File(this.project.getBasedir(), "target/generated-test-sources/injected");
        try {
            Files.createDirectories(f.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create injected test directory", (Exception)e);
        }
        File javaFile = new File(f, this.injectedTestName + ".java");
        try (PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(javaFile), StandardCharsets.UTF_8));){
            w.println("import java.util.*;");
            w.println("/**");
            w.println(" * Entry point to auto-generated tests (generated by maven-hpi-plugin).");
            w.println(" * If this fails to compile, you are probably using Hudson &lt; 1.327. If so, disable");
            w.println(" * this code generation by configuring maven-hpi-plugin to &lt;disabledTestInjection&gt;true&lt;/disabledTestInjection&gt;.");
            w.println(" */");
            w.println("public class " + this.injectedTestName + " extends junit.framework.TestCase {");
            w.println("  public static junit.framework.Test suite() throws Exception {");
            w.println("    System.out.println(\"Running tests for \"+" + TestInsertionMojo.quote(this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion()) + ");");
            w.println("    Map<String, Object> parameters = new HashMap<String, Object>();");
            w.println("    parameters.put(\"basedir\"," + TestInsertionMojo.quote(this.project.getBasedir().getAbsolutePath()) + ");");
            w.println("    parameters.put(\"artifactId\"," + TestInsertionMojo.quote(this.project.getArtifactId()) + ");");
            w.println("    parameters.put(\"packaging\"," + TestInsertionMojo.quote(this.project.getPackaging()) + ");");
            w.println("    parameters.put(\"outputDirectory\"," + TestInsertionMojo.quote(this.project.getBuild().getOutputDirectory()) + ");");
            w.println("    parameters.put(\"testOutputDirectory\"," + TestInsertionMojo.quote(this.project.getBuild().getTestOutputDirectory()) + ");");
            w.println("    parameters.put(\"requirePI\"," + TestInsertionMojo.quote(String.valueOf(this.requirePI)) + ");");
            w.println("    return org.jvnet.hudson.test.PluginAutomaticTestBuilder.build(parameters);");
            w.println("  }");
            w.println("}");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create injected tests", (Exception)e);
        }
        this.project.addTestCompileSourceRoot(f.getAbsolutePath());
        try {
            Files.setLastModifiedTime(javaFile.toPath(), FileTime.fromMillis(0L));
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failed to clear last modified time on " + javaFile), (Throwable)e);
        }
    }
}

