/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jetty.maven.plugin.ConsoleScanner;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.eclipse.jetty.maven.plugin.MavenServerConnector;
import org.eclipse.jetty.maven.plugin.PluginLog;
import org.eclipse.jetty.maven.plugin.ServerSupport;
import org.eclipse.jetty.maven.plugin.SystemProperties;
import org.eclipse.jetty.maven.plugin.SystemProperty;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.PathWatcher;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;

public abstract class AbstractJettyMojo
extends AbstractMojo {
    @Parameter(defaultValue="false")
    protected boolean useProvidedScope;
    @Parameter
    protected String[] excludedGoals;
    @Parameter
    protected ContextHandler[] contextHandlers;
    @Parameter
    protected LoginService[] loginServices;
    @Parameter
    protected RequestLog requestLog;
    @Parameter(alias="webAppConfig")
    protected JettyWebAppContext webApp;
    @Parameter(property="jetty.scanIntervalSeconds", defaultValue="0", required=true)
    protected int scanIntervalSeconds;
    @Parameter(property="jetty.reload", defaultValue="automatic")
    protected String reload;
    @Parameter(property="jetty.systemPropertiesFile")
    protected File systemPropertiesFile;
    @Parameter
    protected SystemProperties systemProperties;
    @Parameter(alias="jettyConfig")
    protected String jettyXml;
    @Parameter
    protected int stopPort;
    @Parameter
    protected String stopKey;
    @Parameter(property="dumponStart", defaultValue="false")
    protected boolean dumpOnStart;
    @Parameter(property="jetty.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(alias="webAppXml")
    protected String contextXml;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.artifacts}", readonly=true)
    protected Set<Artifact> projectArtifacts;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    protected MojoExecution execution;
    @Parameter(defaultValue="${plugin.artifacts}", readonly=true)
    protected List<Artifact> pluginArtifacts;
    @Parameter
    protected MavenServerConnector httpConnector;
    protected Server server;
    protected PathWatcher scanner;
    protected Thread consoleScanner;
    protected ServerSupport serverSupport;
    @Parameter(defaultValue="false")
    protected boolean nonBlocking = false;
    @Parameter
    protected List<String> supportedPackagings = Collections.singletonList("war");

    public abstract void restartWebApp(boolean var1) throws Exception;

    public boolean checkPomConfiguration() throws MojoExecutionException {
        return true;
    }

    public abstract void configureScanner() throws MojoExecutionException;

    protected String getSkipMessage(String reason) {
        String projectName = this.project.getName();
        if (StringUtils.isBlank((String)projectName)) {
            projectName = this.project.getGroupId() + ":" + this.project.getArtifactId();
        }
        return "Skipping " + projectName + " : " + reason;
    }

    public boolean checkPackagingConfiguration() {
        if (!this.supportedPackagings.contains(this.project.getPackaging())) {
            this.getLog().info((CharSequence)this.getSkipMessage("packaging type [" + this.project.getPackaging() + "] is unsupported"));
            return false;
        }
        return true;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isConfigurationSupported()) {
            if (this.skip) {
                this.getLog().info((CharSequence)this.getSkipMessage("jetty.skip==true"));
                return;
            }
            this.getLog().info((CharSequence)("Configuring Jetty for project: " + this.project.getName()));
            if (this.isExcluded(this.execution.getMojoDescriptor().getGoal())) {
                this.getLog().info((CharSequence)("The goal \"" + this.execution.getMojoDescriptor().getFullGoalName() + "\" has been made unavailable for this web application by an <excludedGoal> configuration."));
                return;
            }
            this.configurePluginClasspath();
            PluginLog.setLog(this.getLog());
            this.startJetty();
        }
    }

    public boolean isConfigurationSupported() throws MojoExecutionException {
        return this.checkPackagingConfiguration() && this.checkPomConfiguration();
    }

    public void configurePluginClasspath() throws MojoExecutionException {
        if (this.useProvidedScope) {
            try {
                ArrayList<URL> provided = new ArrayList<URL>();
                for (Artifact artifact : this.projectArtifacts) {
                    if (!"provided".equals(artifact.getScope()) || this.isPluginArtifact(artifact)) continue;
                    provided.add(artifact.getFile().toURI().toURL());
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)("Adding provided artifact: " + artifact));
                }
                if (!provided.isEmpty()) {
                    Object[] urls = (URL[])provided.stream().toArray(URL[]::new);
                    URLClassLoader loader = new URLClassLoader((URL[])urls, ((Object)((Object)this)).getClass().getClassLoader());
                    Thread.currentThread().setContextClassLoader(loader);
                    this.getLog().info((CharSequence)("Plugin classpath augmented with <scope>provided</scope> dependencies: " + Arrays.toString(urls)));
                }
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Invalid url", (Exception)e);
            }
        }
    }

    public boolean isPluginArtifact(Artifact artifact) {
        if (this.pluginArtifacts == null || this.pluginArtifacts.isEmpty()) {
            return false;
        }
        for (Artifact pluginArtifact : this.pluginArtifacts) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Checking " + pluginArtifact));
            }
            if (!pluginArtifact.getGroupId().equals(artifact.getGroupId()) || !pluginArtifact.getArtifactId().equals(artifact.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    public void finishConfigurationBeforeStart() throws Exception {
        HandlerCollection contexts = (HandlerCollection)this.server.getChildHandlerByClass(ContextHandlerCollection.class);
        if (contexts == null) {
            contexts = (HandlerCollection)this.server.getChildHandlerByClass(HandlerCollection.class);
        }
        for (int i = 0; this.contextHandlers != null && i < this.contextHandlers.length; ++i) {
            contexts.addHandler((Handler)this.contextHandlers[i]);
        }
    }

    public void applyJettyXml() throws Exception {
        Server tmp = ServerSupport.applyXmlConfigurations(this.server, this.getJettyXmlFiles());
        if (this.server == null) {
            this.server = tmp;
        }
        if (this.server == null) {
            this.server = new Server();
        }
    }

    public void startJetty() throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)"Starting Jetty Server ...");
            Resource.setDefaultUseCaches((boolean)false);
            this.configureMonitor();
            this.printSystemProperties();
            this.applyJettyXml();
            if (this.httpConnector != null) {
                if (this.httpConnector.getPort() <= 0) {
                    String tmp = System.getProperty(MavenServerConnector.PORT_SYSPROPERTY, System.getProperty("jetty.port", MavenServerConnector.DEFAULT_PORT_STR));
                    this.httpConnector.setPort(Integer.parseInt(tmp.trim()));
                }
                this.httpConnector.setServer(this.server);
            }
            ServerSupport.configureConnectors(this.server, this.httpConnector);
            ServerSupport.configureHandlers(this.server, this.requestLog);
            ServerSupport.configureDefaultConfigurationClasses(this.server);
            this.configureWebApplication();
            ServerSupport.addWebApplication(this.server, this.webApp);
            ServerSupport.configureLoginServices(this.server, this.loginServices);
            this.finishConfigurationBeforeStart();
            this.server.start();
            this.getLog().info((CharSequence)"Started Jetty Server");
            if (this.dumpOnStart) {
                this.getLog().info((CharSequence)this.server.dump());
            }
            if (this.isScanningEnabled()) {
                this.scanner = new PathWatcher();
                this.configureScanner();
                this.startScanner();
            }
            this.startConsoleScanner();
            if (!this.nonBlocking) {
                this.server.join();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure", e);
        }
        finally {
            if (!this.nonBlocking) {
                this.getLog().info((CharSequence)"Jetty server exiting.");
            }
        }
    }

    public void configureMonitor() {
        if (this.stopPort > 0 && this.stopKey != null) {
            ShutdownMonitor monitor = ShutdownMonitor.getInstance();
            monitor.setPort(this.stopPort);
            monitor.setKey(this.stopKey);
            monitor.setExitVm(!this.nonBlocking);
        }
    }

    public void configureWebApplication() throws Exception {
        String cp;
        if (this.webApp == null) {
            this.webApp = new JettyWebAppContext();
        }
        if (this.contextXml != null) {
            Path path = Paths.get(this.contextXml, new String[0]);
            if (!path.isAbsolute()) {
                Path workDir = Paths.get(System.getProperty("user.dir"), new String[0]);
                path = workDir.resolve(path);
                this.contextXml = path.toFile().getAbsolutePath();
            }
            XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.toURL((File)path.toFile()));
            this.getLog().info((CharSequence)("Applying context xml file " + this.contextXml));
            xmlConfiguration.configure((Object)this.webApp);
        }
        if ((cp = this.webApp.getContextPath()) == null || "".equals(cp)) {
            cp = "/" + this.project.getArtifactId();
            this.webApp.setContextPath(cp);
        }
        if (this.webApp.getTempDirectory() == null) {
            File target = new File(this.project.getBuild().getDirectory());
            File tmp = new File(target, "tmp");
            if (!tmp.exists()) {
                tmp.mkdirs();
            }
            this.webApp.setTempDirectory(tmp);
        }
        this.getLog().info((CharSequence)("Context path = " + this.webApp.getContextPath()));
        this.getLog().info((CharSequence)("Tmp directory = " + (this.webApp.getTempDirectory() == null ? " determined at runtime" : this.webApp.getTempDirectory())));
        this.getLog().info((CharSequence)("Web defaults = " + (this.webApp.getDefaultsDescriptor() == null ? " jetty default" : this.webApp.getDefaultsDescriptor())));
        this.getLog().info((CharSequence)("Web overrides = " + (this.webApp.getOverrideDescriptor() == null ? " none" : this.webApp.getOverrideDescriptor())));
    }

    public void startScanner() throws Exception {
        if (!this.isScanningEnabled()) {
            return;
        }
        this.scanner.setNotifyExistingOnStart(false);
        this.scanner.start();
    }

    public boolean isScanningEnabled() {
        return this.scanIntervalSeconds > 0 && !"manual".equalsIgnoreCase(this.reload);
    }

    public void stopScanner() throws Exception {
        if (!this.isScanningEnabled()) {
            return;
        }
        if (this.scanner != null) {
            this.scanner.stop();
        }
    }

    protected void startConsoleScanner() throws Exception {
        if ("manual".equalsIgnoreCase(this.reload)) {
            this.getLog().info((CharSequence)"Console reloading is ENABLED. Hit ENTER on the console to restart the context.");
            this.consoleScanner = new ConsoleScanner(this);
            this.consoleScanner.start();
        }
    }

    protected void printSystemProperties() {
        if (this.getLog().isDebugEnabled() && this.systemProperties != null) {
            this.systemProperties.getSystemProperties().stream().forEach(prop -> this.getLog().debug((CharSequence)("Property " + prop.getName() + "=" + prop.getValue() + " was " + (prop.isSet() ? "set" : "skipped"))));
        }
    }

    public File findJettyWebXmlFile(File webInfDir) {
        if (webInfDir == null) {
            return null;
        }
        if (!webInfDir.exists()) {
            return null;
        }
        File f = new File(webInfDir, "jetty-web.xml");
        if (f.exists()) {
            return f;
        }
        f = new File(webInfDir, "web-jetty.xml");
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public void setSystemPropertiesFile(File file) throws Exception {
        this.systemPropertiesFile = file;
        Properties properties = new Properties();
        try (FileInputStream propFile = new FileInputStream(this.systemPropertiesFile);){
            properties.load(propFile);
        }
        if (this.systemProperties == null) {
            this.systemProperties = new SystemProperties();
        }
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (this.systemProperties.containsSystemProperty(key)) continue;
            SystemProperty prop = new SystemProperty();
            prop.setKey(key);
            prop.setValue(properties.getProperty(key));
            this.systemProperties.setSystemProperty(prop);
        }
    }

    public void setSystemProperties(SystemProperties systemProperties) {
        if (this.systemProperties == null) {
            this.systemProperties = systemProperties;
        } else {
            for (SystemProperty prop : systemProperties.getSystemProperties()) {
                this.systemProperties.setSystemProperty(prop);
            }
        }
    }

    public List<File> getJettyXmlFiles() {
        if (this.jettyXml == null) {
            return null;
        }
        ArrayList<File> jettyXmlFiles = new ArrayList<File>();
        if (this.jettyXml.indexOf(44) == -1) {
            jettyXmlFiles.add(new File(this.jettyXml));
        } else {
            String[] files;
            for (String file : files = StringUtil.csvSplit((String)this.jettyXml)) {
                jettyXmlFiles.add(new File(file));
            }
        }
        return jettyXmlFiles;
    }

    public boolean isExcluded(String goal) {
        if (this.excludedGoals == null || goal == null) {
            return false;
        }
        if ("".equals(goal = goal.trim())) {
            return false;
        }
        boolean excluded = false;
        for (int i = 0; i < this.excludedGoals.length && !excluded; ++i) {
            if (!this.excludedGoals[i].equalsIgnoreCase(goal)) continue;
            excluded = true;
        }
        return excluded;
    }
}

