/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.eclipse.jetty.maven.plugin.JettyRunMojo;
import org.eclipse.jetty.maven.plugin.WebAppPropertyConverter;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;

@Mojo(name="run-distro", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class JettyRunDistro
extends JettyRunMojo {
    public static final String JETTY_HOME_GROUPID = "org.eclipse.jetty";
    public static final String JETTY_HOME_ARTIFACTID = "jetty-home";
    @Parameter(defaultValue="${plugin}", required=true, readonly=true)
    protected PluginDescriptor plugin;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    protected File target;
    @Parameter
    private File jettyHome;
    @Parameter
    private File jettyBase;
    @Parameter
    private String[] modules;
    @Parameter(property="jetty.jvmArgs")
    private String jvmArgs;
    @Parameter
    private Map<String, String> env = new HashMap<String, String>();
    @Parameter
    private String[] jettyProperties;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> remoteRepositories;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${plugin.version}", readonly=true)
    private String pluginVersion;
    @Parameter(defaultValue="true")
    private boolean waitForChild;
    @Parameter(defaultValue="10")
    private int maxChildChecks;
    @Parameter(defaultValue="100")
    private long maxChildCheckInterval;
    private File targetBase;
    private List<Dependency> libExtJars;
    private Random random;
    private Path tokenFile;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.random = new Random();
        List pdeps = this.plugin.getPlugin().getDependencies();
        if (pdeps != null && !pdeps.isEmpty()) {
            boolean warned = false;
            for (Dependency d : pdeps) {
                if (d.getGroupId().equalsIgnoreCase(JETTY_HOME_GROUPID)) {
                    if (warned) continue;
                    this.getLog().warn((CharSequence)"Jetty jars detected in <pluginDependencies>: use <modules> in <configuration> parameter instead to select appropriate jetty modules.");
                    warned = true;
                    continue;
                }
                if (this.libExtJars == null) {
                    this.libExtJars = new ArrayList<Dependency>();
                }
                this.libExtJars.add(d);
            }
        }
        super.execute();
    }

    @Override
    public void startJetty() throws MojoExecutionException {
        try {
            this.printSystemProperties();
            this.configureJettyHome();
            this.configureWebApplication();
            this.configureJettyBase();
            ProcessBuilder command = this.configureCommand();
            if (this.waitForChild) {
                command.inheritIO();
            } else {
                command.redirectOutput(new File(this.target, "jetty.out"));
                command.redirectErrorStream(true);
            }
            Process process = command.start();
            if (this.waitForChild) {
                process.waitFor();
            } else {
                int attempts;
                for (attempts = this.maxChildChecks; !Files.exists(this.tokenFile, new LinkOption[0]) && attempts > 0; --attempts) {
                    Thread.currentThread();
                    Thread.sleep(this.maxChildCheckInterval);
                }
                if (attempts <= 0) {
                    this.getLog().info((CharSequence)"Couldn't verify success of child startup");
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to start Jetty", e);
        }
    }

    public void configureJettyHome() throws Exception {
        if (this.jettyHome == null) {
            Artifact jettyHomeArtifact = this.resolveArtifact(JETTY_HOME_GROUPID, JETTY_HOME_ARTIFACTID, this.pluginVersion, "zip");
            JarResource res = (JarResource)JarResource.newJarResource((Resource)Resource.newResource((File)jettyHomeArtifact.getFile()));
            res.copyTo(this.target);
            this.jettyHome = new File(this.target, "jetty-home-" + this.pluginVersion);
        } else if (!this.jettyHome.exists()) {
            throw new IllegalStateException(this.jettyHome.getAbsolutePath() + " does not exist");
        }
        this.getLog().info((CharSequence)("jetty.home = " + this.jettyHome.getAbsolutePath()));
    }

    public Artifact resolveArtifact(String groupId, String artifactId, String version, String extension) throws ArtifactResolverException {
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(groupId);
        coordinate.setArtifactId(artifactId);
        coordinate.setVersion(version);
        coordinate.setExtension(extension);
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.remoteRepositories);
        return this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, (ArtifactCoordinate)coordinate).getArtifact();
    }

    public void configureJettyBase() throws Exception {
        Throwable throwable;
        FileOutputStream fileStream2;
        if (this.jettyBase != null && !this.jettyBase.exists()) {
            throw new IllegalStateException(this.jettyBase.getAbsolutePath() + " does not exist");
        }
        this.targetBase = new File(this.target, "jetty-base");
        final Path targetBasePath = this.targetBase.toPath();
        Files.deleteIfExists(this.targetBase.toPath());
        this.targetBase.mkdirs();
        if (this.jettyBase != null) {
            final Path jettyBasePath = this.jettyBase.toPath();
            Files.walkFileTree(jettyBasePath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    block2: {
                        Path targetDir = targetBasePath.resolve(jettyBasePath.relativize(dir));
                        try {
                            Files.copy(dir, targetDir, new CopyOption[0]);
                        }
                        catch (FileAlreadyExistsException e) {
                            if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                            throw e;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (JettyRunDistro.this.contextXml != null && Files.isSameFile(Paths.get(JettyRunDistro.this.contextXml, new String[0]), file)) {
                        return FileVisitResult.CONTINUE;
                    }
                    Files.copy(file, targetBasePath.resolve(jettyBasePath.relativize(file)), new CopyOption[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        Path modulesPath = Files.createDirectories(targetBasePath.resolve("modules"), new FileAttribute[0]);
        Path etcPath = Files.createDirectories(targetBasePath.resolve("etc"), new FileAttribute[0]);
        Path libPath = Files.createDirectories(targetBasePath.resolve("lib"), new FileAttribute[0]);
        Path webappPath = Files.createDirectories(targetBasePath.resolve("webapps"), new FileAttribute[0]);
        Path mavenLibPath = Files.createDirectories(libPath.resolve("maven"), new FileAttribute[0]);
        URI thisJar = TypeUtil.getLocationOfClass(((Object)((Object)this)).getClass());
        if (thisJar == null) {
            throw new IllegalStateException("Can't find jar for jetty-maven-plugin");
        }
        InputStream jarStream = thisJar.toURL().openStream();
        Object object = null;
        try {
            fileStream2 = new FileOutputStream(mavenLibPath.resolve("plugin.jar").toFile());
            throwable = null;
            try {
                IO.copy((InputStream)jarStream, (OutputStream)fileStream2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileStream2 != null) {
                    if (throwable != null) {
                        try {
                            fileStream2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        fileStream2.close();
                    }
                }
            }
        }
        catch (Throwable fileStream2) {
            object = fileStream2;
            throw fileStream2;
        }
        finally {
            if (jarStream != null) {
                if (object != null) {
                    try {
                        jarStream.close();
                    }
                    catch (Throwable fileStream2) {
                        ((Throwable)object).addSuppressed(fileStream2);
                    }
                } else {
                    jarStream.close();
                }
            }
        }
        InputStream mavenXmlStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("maven.xml");
        object = null;
        try {
            fileStream2 = new FileOutputStream(webappPath.resolve("maven.xml").toFile());
            throwable = null;
            try {
                IO.copy((InputStream)mavenXmlStream, (OutputStream)fileStream2);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (fileStream2 != null) {
                    if (throwable != null) {
                        try {
                            fileStream2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        fileStream2.close();
                    }
                }
            }
        }
        catch (Throwable fileStream3) {
            object = fileStream3;
            throw fileStream3;
        }
        finally {
            if (mavenXmlStream != null) {
                if (object != null) {
                    try {
                        mavenXmlStream.close();
                    }
                    catch (Throwable fileStream3) {
                        ((Throwable)object).addSuppressed(fileStream3);
                    }
                } else {
                    mavenXmlStream.close();
                }
            }
        }
        InputStream mavenModStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("maven.mod");
        object = null;
        try {
            fileStream2 = new FileOutputStream(modulesPath.resolve("maven.mod").toFile());
            throwable = null;
            try {
                IO.copy((InputStream)mavenModStream, (OutputStream)fileStream2);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (fileStream2 != null) {
                    if (throwable != null) {
                        try {
                            fileStream2.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        fileStream2.close();
                    }
                }
            }
        }
        catch (Throwable fileStream4) {
            object = fileStream4;
            throw fileStream4;
        }
        finally {
            if (mavenModStream != null) {
                if (object != null) {
                    try {
                        mavenModStream.close();
                    }
                    catch (Throwable fileStream4) {
                        ((Throwable)object).addSuppressed(fileStream4);
                    }
                } else {
                    mavenModStream.close();
                }
            }
        }
        InputStream jettyMavenStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("jetty-maven.xml");
        object = null;
        try {
            fileStream2 = new FileOutputStream(etcPath.resolve("jetty-maven.xml").toFile());
            throwable = null;
            try {
                IO.copy((InputStream)jettyMavenStream, (OutputStream)fileStream2);
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (fileStream2 != null) {
                    if (throwable != null) {
                        try {
                            fileStream2.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        fileStream2.close();
                    }
                }
            }
        }
        catch (Throwable fileStream5) {
            object = fileStream5;
            throw fileStream5;
        }
        finally {
            if (jettyMavenStream != null) {
                if (object != null) {
                    try {
                        jettyMavenStream.close();
                    }
                    catch (Throwable fileStream5) {
                        ((Throwable)object).addSuppressed(fileStream5);
                    }
                } else {
                    jettyMavenStream.close();
                }
            }
        }
        if (this.libExtJars != null && !this.libExtJars.isEmpty()) {
            Path libExtPath = Files.createDirectories(libPath.resolve("ext"), new FileAttribute[0]);
            for (Dependency d : this.libExtJars) {
                Artifact a = this.resolveArtifact(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getType());
                FileInputStream jarStream2 = new FileInputStream(a.getFile());
                Throwable throwable10 = null;
                try {
                    FileOutputStream fileStream6 = new FileOutputStream(libExtPath.resolve(d.getGroupId() + "." + d.getArtifactId() + "-" + d.getVersion() + "." + d.getType()).toFile());
                    Throwable throwable11 = null;
                    try {
                        IO.copy((InputStream)jarStream2, (OutputStream)fileStream6);
                    }
                    catch (Throwable throwable12) {
                        throwable11 = throwable12;
                        throw throwable12;
                    }
                    finally {
                        if (fileStream6 == null) continue;
                        if (throwable11 != null) {
                            try {
                                fileStream6.close();
                            }
                            catch (Throwable throwable13) {
                                throwable11.addSuppressed(throwable13);
                            }
                            continue;
                        }
                        fileStream6.close();
                    }
                }
                catch (Throwable throwable14) {
                    throwable10 = throwable14;
                    throw throwable14;
                }
                finally {
                    if (jarStream2 == null) continue;
                    if (throwable10 != null) {
                        try {
                            ((InputStream)jarStream2).close();
                        }
                        catch (Throwable throwable15) {
                            throwable10.addSuppressed(throwable15);
                        }
                        continue;
                    }
                    ((InputStream)jarStream2).close();
                }
            }
        }
        this.createPropertiesFile(etcPath.resolve("maven.props").toFile());
    }

    public void createPropertiesFile(File file) throws Exception {
        WebAppPropertyConverter.toProperties(this.webApp, file, this.contextXml);
    }

    public ProcessBuilder configureCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("java");
        cmd.add("-jar");
        cmd.add(new File(this.jettyHome, "start.jar").getAbsolutePath());
        cmd.add("-DSTOP.PORT=" + this.stopPort);
        if (this.stopKey != null) {
            cmd.add("-DSTOP.KEY=" + this.stopKey);
        }
        if (this.jvmArgs != null) {
            String[] args;
            for (String a : args = this.jvmArgs.split(" ")) {
                if (StringUtil.isBlank((String)a)) continue;
                cmd.add(a.trim());
            }
        }
        StringBuilder tmp = new StringBuilder();
        tmp.append("--module=");
        tmp.append("server,http,webapp,deploy");
        if (this.modules != null) {
            for (String m : this.modules) {
                if (tmp.indexOf(m) >= 0) continue;
                tmp.append("," + m);
            }
        }
        if (this.libExtJars != null && !this.libExtJars.isEmpty() && tmp.indexOf("ext") < 0) {
            tmp.append(",ext");
        }
        tmp.append(",maven");
        cmd.add(tmp.toString());
        if (this.jettyProperties != null) {
            for (String p : this.jettyProperties) {
                cmd.add(p);
            }
        }
        this.tokenFile = this.target.toPath().resolve(this.createToken() + ".txt");
        cmd.add("jetty.token.file=" + this.tokenFile.toAbsolutePath().toString());
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.directory(this.targetBase);
        if (!this.env.isEmpty()) {
            builder.environment().putAll(this.env);
        }
        return builder;
    }

    @Override
    public void startScanner() throws Exception {
    }

    @Override
    public void stopScanner() throws Exception {
    }

    @Override
    public void restartWebApp(boolean reconfigureScanner) throws Exception {
    }

    @Override
    public void configureScanner() throws MojoExecutionException {
    }

    private String createToken() {
        return Long.toString(this.random.nextLong() ^ System.currentTimeMillis(), 36).toUpperCase(Locale.ENGLISH);
    }
}

