/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.channel;

import com.trilead.ssh2.channel.ChannelInputStream;
import com.trilead.ssh2.channel.ChannelManager;
import com.trilead.ssh2.channel.ChannelOutputStream;
import com.trilead.ssh2.channel.FifoBuffer;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.packets.PacketSignal;
import com.trilead.ssh2.packets.PacketWindowChange;
import com.trilead.ssh2.transport.TransportManager;
import com.trilead.ssh2.util.IOUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class Channel {
    static final int STATE_OPENING = 1;
    static final int STATE_OPEN = 2;
    static final int STATE_CLOSED = 4;
    private static final int CHANNEL_BUFFER_SIZE = Integer.getInteger(Channel.class.getName() + ".bufferSize", 0x104000);
    int channelBufferSize = CHANNEL_BUFFER_SIZE;
    final ChannelManager cm;
    final ChannelOutputStream stdinStream;
    final Output stdout = new Output();
    final Output stderr = new Output();
    int localID = -1;
    int remoteID = -1;
    final Object channelSendLock = new Object();
    boolean closeMessageSent = false;
    final byte[] msgWindowAdjust = new byte[9];
    int state = 1;
    boolean closeMessageRecv = false;
    int successCounter = 0;
    int failedCounter = 0;
    int localWindow = 0;
    long remoteWindow = 0L;
    int localMaxPacketSize = -1;
    int remoteMaxPacketSize = -1;
    private boolean eof = false;
    Integer exit_status;
    String exit_signal;
    String hexX11FakeCookie;
    private final Object reasonClosedLock = new Object();
    private Throwable reasonClosed = null;
    private static final Logger log = Logger.getLogger(Channel.class);

    synchronized void eof() {
        this.stdout.eof();
        this.stderr.eof();
        this.eof = true;
    }

    boolean isEOF() {
        return this.eof;
    }

    public Channel(ChannelManager cm) {
        this.cm = cm;
        this.localWindow = this.channelBufferSize;
        this.localMaxPacketSize = TransportManager.MAX_PACKET_SIZE - 1024;
        this.stdinStream = new ChannelOutputStream(this);
        this.stdout.stream = new ChannelInputStream(this, false);
        this.stderr.stream = new ChannelInputStream(this, true);
    }

    public synchronized void setWindowSize(int newSize) {
        if (newSize <= 0) {
            throw new IllegalArgumentException("Invalid value: " + newSize);
        }
        this.channelBufferSize = newSize;
    }

    public ChannelInputStream getStderrStream() {
        return this.stderr.stream;
    }

    public ChannelOutputStream getStdinStream() {
        return this.stdinStream;
    }

    public ChannelInputStream getStdoutStream() {
        return this.stdout.stream;
    }

    public synchronized void pipeStdoutStream(OutputStream os) throws IOException {
        this.stdout.pipeTo(os);
    }

    public synchronized void pipeStderrStream(OutputStream os) throws IOException {
        this.stderr.pipeTo(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExitSignal() {
        Channel channel = this;
        synchronized (channel) {
            return this.exit_signal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getExitStatus() {
        Channel channel = this;
        synchronized (channel) {
            return this.exit_status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReasonClosed() {
        Object object = this.reasonClosedLock;
        synchronized (object) {
            return this.reasonClosed != null ? this.reasonClosed.getMessage() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getReasonClosedCause() {
        Object object = this.reasonClosedLock;
        synchronized (object) {
            return this.reasonClosed;
        }
    }

    public void setReasonClosed(String reasonClosed) {
        this.setReasonClosed(new IOException(reasonClosed));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReasonClosed(Throwable reasonClosed) {
        Object object = this.reasonClosedLock;
        synchronized (object) {
            if (this.reasonClosed == null) {
                this.reasonClosed = reasonClosed;
            }
        }
    }

    void freeupWindow(int copylen) throws IOException {
        this.freeupWindow(copylen, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeupWindow(int copylen, boolean sendAsync) throws IOException {
        int localID;
        int remoteID;
        if (copylen <= 0) {
            return;
        }
        int increment = 0;
        Object object = this;
        synchronized (object) {
            int space;
            if (this.localWindow <= this.channelBufferSize * 3 / 4 && (increment = (space = this.channelBufferSize - this.stdout.readable() - this.stderr.readable()) - this.localWindow) > 0) {
                this.localWindow += increment;
            }
            remoteID = this.remoteID;
            localID = this.localID;
        }
        if (increment > 0) {
            if (log.isEnabled()) {
                log.log(80, "Sending SSH_MSG_CHANNEL_WINDOW_ADJUST (channel " + localID + ", " + increment + ")");
            }
            object = this.channelSendLock;
            synchronized (object) {
                byte[] msg = this.msgWindowAdjust;
                msg[0] = 93;
                msg[1] = (byte)(remoteID >> 24);
                msg[2] = (byte)(remoteID >> 16);
                msg[3] = (byte)(remoteID >> 8);
                msg[4] = (byte)remoteID;
                msg[5] = (byte)(increment >> 24);
                msg[6] = (byte)(increment >> 16);
                msg[7] = (byte)(increment >> 8);
                msg[8] = (byte)increment;
                if (!this.closeMessageSent) {
                    if (sendAsync) {
                        this.cm.tm.sendAsynchronousMessage(msg);
                    } else {
                        this.cm.tm.sendMessage(msg);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestWindowChange(int term_width_characters, int term_height_characters, int term_width_pixels, int term_height_pixels) throws IOException {
        PacketWindowChange pwc;
        Object object = this;
        synchronized (object) {
            if (this.state != 2) {
                throw (IOException)new IOException("Cannot request window-change on this channel").initCause(this.getReasonClosedCause());
            }
            pwc = new PacketWindowChange(this.remoteID, term_width_characters, term_height_characters, term_width_pixels, term_height_pixels);
        }
        object = this.channelSendLock;
        synchronized (object) {
            if (this.closeMessageSent) {
                throw (IOException)new IOException("Cannot request window-change on this channel").initCause(this.getReasonClosedCause());
            }
            this.cm.tm.sendMessage(pwc.getPayload());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal(String name) throws IOException {
        PacketSignal p;
        Object object = this;
        synchronized (object) {
            if (this.state != 2) {
                throw (IOException)new IOException("Cannot send signal on this channel").initCause(this.getReasonClosedCause());
            }
            p = new PacketSignal(this.remoteID, name);
        }
        object = this.channelSendLock;
        synchronized (object) {
            if (this.closeMessageSent) {
                throw (IOException)new IOException("Cannot request window-change on this channel").initCause(this.getReasonClosedCause());
            }
            this.cm.tm.sendMessage(p.getPayload());
        }
    }

    class Output {
        ChannelInputStream stream;
        FifoBuffer buffer;
        OutputStream sink;

        Output() {
            this.buffer = new FifoBuffer(Channel.this, 2048, Channel.this.channelBufferSize);
        }

        public void write(byte[] buf, int start, int len) throws IOException {
            if (this.buffer != null) {
                try {
                    this.buffer.write(buf, start, len);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            } else {
                this.sink.write(buf, start, len);
                Channel.this.freeupWindow(len, true);
            }
        }

        public int readable() {
            if (this.buffer != null) {
                return this.buffer.readable();
            }
            return 0;
        }

        public int available() {
            if (this.buffer == null) {
                throw new IllegalStateException("Output is being piped to " + String.valueOf(this.sink));
            }
            int sz = this.buffer.readable();
            if (sz > 0) {
                return sz;
            }
            return Channel.this.isEOF() ? -1 : 0;
        }

        public int read(byte[] buf, int start, int len) throws InterruptedException {
            return this.buffer.read(buf, start, len);
        }

        public void eof() {
            if (this.buffer != null) {
                this.buffer.close();
            } else {
                IOUtils.closeQuietly(this.sink);
            }
        }

        public void pipeTo(OutputStream os) throws IOException {
            this.sink = os;
            if (this.buffer.readable() != 0) {
                Channel.this.freeupWindow(this.buffer.writeTo(os));
            }
            this.buffer = null;
            this.stream = null;
        }
    }
}

