/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.RSAPrivateKeySpec;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import javax.net.ssl.KeyManagerFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import winstone.ConnectorFactory;
import winstone.Logger;
import winstone.WinstoneException;
import winstone.WinstoneResourceBundle;
import winstone.cmdline.Option;

public abstract class AbstractSecuredConnectorFactory
implements ConnectorFactory {
    protected static final WinstoneResourceBundle SSL_RESOURCES = new WinstoneResourceBundle("winstone.LocalStrings");
    protected KeyStore keystore;
    protected String keystorePassword;

    protected void configureSsl(Map<String, String> args, Server server) throws IOException {
        block17: {
            try {
                File opensslCert = Option.HTTPS_CERTIFICATE.get(args);
                File opensslKey = Option.HTTPS_PRIVATE_KEY.get(args);
                File keyStore = Option.HTTPS_KEY_STORE.get(args);
                String pwd = Option.HTTPS_KEY_STORE_PASSWORD.get(args);
                if (opensslCert != null ^ opensslKey != null) {
                    throw new WinstoneException(MessageFormat.format("--{0} and --{1} need to be used together", Option.HTTPS_CERTIFICATE, Option.HTTPS_PRIVATE_KEY));
                }
                if (keyStore != null && opensslKey != null) {
                    throw new WinstoneException(MessageFormat.format("--{0} and --{1} are mutually exclusive", Option.HTTPS_KEY_STORE, Option.HTTPS_PRIVATE_KEY));
                }
                if (keyStore != null) {
                    if (!keyStore.exists() || !keyStore.isFile()) {
                        throw new WinstoneException(SSL_RESOURCES.getString("HttpsListener.KeyStoreNotFound", keyStore.getPath()));
                    }
                    this.keystorePassword = pwd;
                    this.keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                    try (FileInputStream inputStream = new FileInputStream(keyStore);){
                        this.keystore.load(inputStream, this.keystorePassword.toCharArray());
                        break block17;
                    }
                }
                if (opensslCert != null) {
                    CertificateFactory cf = CertificateFactory.getInstance("X509");
                    try (FileInputStream inputStream = new FileInputStream(opensslCert);){
                        Certificate cert = cf.generateCertificate(inputStream);
                        PrivateKey key = AbstractSecuredConnectorFactory.readPEMRSAPrivateKey(opensslKey);
                        this.keystorePassword = "changeit";
                        this.keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                        this.keystore.load(null);
                        this.keystore.setKeyEntry("hudson", key, this.keystorePassword.toCharArray(), new Certificate[]{cert});
                        break block17;
                    }
                }
                throw new WinstoneException(MessageFormat.format("Please set --{0}", Option.HTTPS_KEY_STORE));
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Failed to handle keys", e);
            }
        }
    }

    private static PrivateKey readPEMRSAPrivateKey(File opensslKey) throws IOException, GeneralSecurityException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            BigInteger privExpo;
            BigInteger mod;
            try (BufferedReader r = Files.newBufferedReader(opensslKey.toPath(), StandardCharsets.US_ASCII);){
                String line;
                boolean in = false;
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("-----")) {
                        in = !in;
                        continue;
                    }
                    if (!in) continue;
                    baos.write(Base64.getDecoder().decode(line.trim()));
                }
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            try {
                Class<?> disC = Class.forName("sun.security.util.DerInputStream");
                Object dis = disC.getConstructor(byte[].class).newInstance(new Object[]{baos.toByteArray()});
                Object[] seq = (Object[])disC.getMethod("getSequence", Integer.TYPE).invoke(dis, 0);
                Method getBigInteger = seq[0].getClass().getMethod("getBigInteger", new Class[0]);
                mod = (BigInteger)getBigInteger.invoke(seq[1], new Object[0]);
                privExpo = (BigInteger)getBigInteger.invoke(seq[3], new Object[0]);
            }
            catch (Exception x) {
                throw new WinstoneException(SSL_RESOURCES.getString("HttpsConnectorFactory.LoadPrivateKeyError"), x);
            }
            Logger.log(Level.WARNING, SSL_RESOURCES, "HttpsConnectorFactory.LoadPrivateKey");
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = kf.generatePrivate(new RSAPrivateKeySpec(mod, privExpo));
            return privateKey;
        }
    }

    protected SslContextFactory getSSLContext(Map<String, String> args) {
        try {
            String privateKeyPassword = Option.HTTPS_PRIVATE_KEY_PASSWORD.get(args, this.keystorePassword);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(Option.HTTPS_KEY_MANAGER_TYPE.get(args));
            kmf.init(this.keystore, this.keystorePassword.toCharArray());
            Logger.log(Logger.FULL_DEBUG, SSL_RESOURCES, "HttpsListener.KeyCount", (Object)(this.keystore.size() + ""));
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Logger.log(Logger.FULL_DEBUG, SSL_RESOURCES, "HttpsListener.KeyFound", alias, this.keystore.getCertificate(alias) + "");
            }
            SslContextFactory.Server ssl = new SslContextFactory.Server();
            ssl.setKeyStore(this.keystore);
            ssl.setKeyStorePassword(this.keystorePassword);
            ssl.setKeyManagerPassword(privateKeyPassword);
            ssl.setKeyManagerFactoryAlgorithm(Option.HTTPS_KEY_MANAGER_TYPE.get(args));
            ssl.setCertAlias(Option.HTTPS_CERTIFICATE_ALIAS.get(args));
            ssl.setExcludeProtocols("SSLv3", "SSLv2", "SSLv2Hello");
            String excludeCiphers = Option.HTTPS_EXCLUDE_CIPHER_SUITES.get(args);
            if (excludeCiphers != null && excludeCiphers.length() > 0) {
                String[] cipherSuites = excludeCiphers.split(",");
                ssl.setExcludeCipherSuites(cipherSuites);
            }
            Logger.log(Logger.INFO, SSL_RESOURCES, "HttpsListener.ExcludeCiphers", Arrays.asList(ssl.getExcludeCipherSuites()));
            ssl.setNeedClientAuth(Option.HTTPS_VERIFY_CLIENT.get(args));
            return ssl;
        }
        catch (Throwable err) {
            throw new WinstoneException(SSL_RESOURCES.getString("HttpsListener.ErrorGettingContext"), err);
        }
    }
}

