/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.kubernetes.auth.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.model.AuthInfoBuilder;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.ConfigBuilder;
import io.fabric8.kubernetes.api.model.ConfigFluent;
import io.fabric8.kubernetes.api.model.NamedContextFluent;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuth;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthConfig;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;
import org.jenkinsci.plugins.kubernetes.credentials.Utils;

abstract class AbstractKubernetesAuth
implements KubernetesAuth {
    AbstractKubernetesAuth() {
    }

    abstract AuthInfoBuilder decorate(AuthInfoBuilder var1, KubernetesAuthConfig var2) throws KubernetesAuthException;

    @Override
    public String buildKubeConfig(KubernetesAuthConfig config) throws JsonProcessingException, KubernetesAuthException {
        ConfigBuilder configBuilder = this.buildConfigBuilder(config, "k8s", "k8s", "cluster-admin");
        return SerializationUtils.getMapper().writeValueAsString((Object)configBuilder.build());
    }

    @Override
    public ConfigBuilder buildConfigBuilder(KubernetesAuthConfig config, String context, String clusterName, String username) throws KubernetesAuthException {
        ConfigBuilder configBuilder = new ConfigBuilder();
        Cluster cluster = new Cluster();
        cluster.setServer(config.getServerUrl());
        String caCertificate = config.getCaCertificate();
        if (caCertificate != null && !caCertificate.isEmpty()) {
            cluster.setCertificateAuthorityData(Utils.encodeBase64(Utils.wrapCertificate(caCertificate)));
        }
        if (config.isSkipTlsVerify()) {
            cluster.setInsecureSkipTlsVerify(Boolean.valueOf(config.isSkipTlsVerify()));
        }
        ((ConfigFluent.ClustersNested)((ConfigFluent.ClustersNested)configBuilder.addNewCluster().withName(clusterName)).withCluster(cluster)).endCluster();
        ((ConfigFluent.UsersNested)((ConfigFluent.UsersNested)configBuilder.addNewUser().withName(username)).withUser(this.decorate(new AuthInfoBuilder(), config).build())).endUser();
        ((ConfigFluent.ContextsNested)((NamedContextFluent.ContextNested)((NamedContextFluent.ContextNested)((ConfigFluent.ContextsNested)configBuilder.addNewContext().withName(context)).withNewContext().withCluster(clusterName)).withUser(username)).endContext()).endContext();
        configBuilder.withCurrentContext(context);
        return configBuilder;
    }
}

