/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.kubernetes.tokensource;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import jenkins.authentication.tokens.api.AuthenticationTokenException;
import jenkins.authentication.tokens.api.AuthenticationTokenSource;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.kubernetes.auth.impl.KubernetesAuthKubeconfig;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;

@Extension
public class FileCredentialsTokenSource
extends AuthenticationTokenSource<KubernetesAuthKubeconfig, FileCredentials> {
    public FileCredentialsTokenSource() {
        super(KubernetesAuthKubeconfig.class, FileCredentials.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public KubernetesAuthKubeconfig convert(@NonNull FileCredentials credential) throws AuthenticationTokenException {
        try (InputStream is = credential.getContent();){
            KubernetesAuthKubeconfig kubernetesAuthKubeconfig = new KubernetesAuthKubeconfig(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
            return kubernetesAuthKubeconfig;
        }
        catch (IOException e) {
            throw new AuthenticationTokenException((Throwable)e);
        }
    }
}

