/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTClosureMap;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTKey;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTMethodArg;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public final class ModelASTAgent
extends ModelASTElement {
    private ModelASTMethodArg variables;
    private ModelASTKey agentType;

    public ModelASTAgent(Object sourceLocation) {
        super(sourceLocation);
    }

    public JSONObject toJSON() {
        JSONObject j = new JSONObject();
        j.accumulate("type", this.agentType.toJSON());
        if (this.variables != null) {
            if (this.variables instanceof ModelASTClosureMap && !((ModelASTClosureMap)this.variables).getVariables().isEmpty()) {
                j.accumulate("arguments", this.variables.toJSON());
            } else if (this.variables instanceof ModelASTValue) {
                j.accumulate("argument", this.variables.toJSON());
            }
        }
        return j;
    }

    @Override
    public void validate(@Nonnull ModelValidator validator) {
        validator.validateElement(this);
        if (this.variables != null) {
            this.variables.validate(validator);
        }
    }

    @Override
    public String toGroovy() {
        StringBuilder argStr = new StringBuilder();
        if (this.variables == null || this.variables instanceof ModelASTClosureMap && ((ModelASTClosureMap)this.variables).getVariables().isEmpty()) {
            argStr.append(this.agentType.toGroovy());
        } else {
            argStr.append("{\n");
            argStr.append(this.agentType.toGroovy());
            argStr.append(" ");
            argStr.append(this.variables.toGroovy());
            argStr.append("\n}");
        }
        return "agent " + argStr.toString() + "\n";
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        if (this.agentType != null) {
            this.agentType.removeSourceLocation();
        }
        if (this.variables != null) {
            this.variables.removeSourceLocation();
        }
    }

    public ModelASTKey getAgentType() {
        return this.agentType;
    }

    public void setAgentType(ModelASTKey k) {
        this.agentType = k;
    }

    public ModelASTMethodArg getVariables() {
        return this.variables;
    }

    public void setVariables(ModelASTMethodArg variables) {
        this.variables = variables;
    }

    @Override
    public String toString() {
        return "ModelASTAgent{agentType=" + this.agentType + "variables=" + this.variables + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTAgent that = (ModelASTAgent)o;
        if (this.getAgentType() != null ? !this.getAgentType().equals(that.getAgentType()) : that.getAgentType() != null) {
            return false;
        }
        return this.getVariables() != null ? this.getVariables().equals(that.getVariables()) : that.getVariables() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getAgentType() != null ? this.getAgentType().hashCode() : 0);
        result = 31 * result + (this.getVariables() != null ? this.getVariables().hashCode() : 0);
        return result;
    }
}

